/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.content.type.webapp;

import christophedelory.content.type.ContentType;
import christophedelory.content.type.ContentTypeProvider;
import christophedelory.content.type.webapp.MimeMapping;
import christophedelory.content.type.webapp.WebApp;
import christophedelory.xml.XmlSerializer;
import java.net.URL;

public class WebAppProvider
implements ContentTypeProvider {
    private WebApp _webApp;

    public WebAppProvider() {
        try {
            URL url = this.getClass().getClassLoader().getResource("christophedelory/content/type/webapp/web.xml");
            if (url != null) {
                this._webApp = (WebApp)XmlSerializer.getMapping("christophedelory/content/type/webapp").unmarshal(url);
            }
        }
        catch (Exception e) {
            this._webApp = new WebApp();
        }
    }

    @Override
    public ContentType getContentType(String contentName) {
        ContentType ret = null;
        int idx = contentName.lastIndexOf(46);
        if (idx >= 0) {
            String ext = contentName.substring(idx);
            String pattern = contentName.substring(idx + 1).toLowerCase();
            for (MimeMapping mapping : this._webApp.getMimeMappings()) {
                if (!pattern.equals(mapping.getExtension()) || mapping.getMimeType() == null) continue;
                ret = new ContentType(new String[]{ext}, new String[]{mapping.getMimeType()}, null, null);
                break;
            }
        }
        return ret;
    }
}

