/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.lizzy;

import christophedelory.content.Content;
import christophedelory.content.type.ContentType;
import christophedelory.content.type.ContentTypesFileFilter;
import christophedelory.lizzy.FetchContentMetadata;
import christophedelory.lizzy.Transcode;
import christophedelory.playlist.Media;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistFactory;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.m3u.M3U;
import christophedelory.playlist.plp.PLP;
import christophedelory.playlist.rss.RSSProvider;
import christophedelory.xml.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class AddToPlaylist {
    @Option(name="-t", usage="The output playlist type\nAllowed values: see below", metaVar="type")
    private volatile String _type = null;
    @Option(name="-m", usage="Fetch if possible the media content metadata")
    private volatile boolean _fetchContentMetadata = false;
    @Option(name="-r", usage="Recursively add sub-directories contents")
    private volatile boolean _recursive = false;
    @Option(name="-o", usage="The output file or URL\nIf missing, a file save dialog is prompted\nIf the output playlist type is not specified (-t), it will be inferred from the output file name extension", metaVar="file/URL")
    private volatile String _output = null;
    @Option(name="-m3u:ext", usage="The output M3U playlist must use the Extension M3U format")
    private volatile boolean _extM3U = false;
    @Option(name="-rss:media", usage="The output RSS playlist must use the RSS Media format")
    private volatile boolean _useRSSMedia = false;
    @Option(name="-plp:disk", usage="The disk identifier of the output PLP playlist\nExamples: HARP, HDD", metaVar="disk")
    private volatile String _diskSpecifier = null;
    @Argument(usage="One or more files or directories to add to the output playlist", metaVar="input-files(s)", required=true)
    private volatile ArrayList<String> _arguments = new ArrayList();

    public static void main(String[] args) throws Exception {
        Transcode.buildCurrentVersion("christophedelory/lizzy/VERSION");
        System.err.println("*** Lizzy AddToPlaylist v" + Version.CURRENT);
        System.err.println("*** Copyright (c) 2008-2009, Christophe Delory");
        System.err.println();
        AddToPlaylist program = new AddToPlaylist();
        CmdLineParser parser = new CmdLineParser((Object)program);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println("Adds URLs, files and/or directories to a (possibly new) single playlist");
            System.err.println("usage: AddToPlaylist [options] <input-file(s)>");
            parser.printUsage((OutputStream)System.err);
            System.err.println("Supported playlist provider types: " + program.getSupportedProviderIds());
            System.exit(1);
        }
        program.run();
    }

    private AddToPlaylist() {
    }

    public String getSupportedProviderIds() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (SpecificPlaylistProvider provider : SpecificPlaylistFactory.getInstance().getProviders()) {
            if (!first) {
                sb.append('/');
            }
            first = false;
            sb.append(provider.getId());
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void run() throws Exception {
        OutputStream out;
        SpecificPlaylist outputSpecificPlaylist;
        URL outputUrl;
        SpecificPlaylistProvider provider = null;
        if (this._type != null && (provider = SpecificPlaylistFactory.getInstance().findProviderById(this._type)) == null) {
            System.err.println("Unknown specific playlist type <" + this._type + '>');
            System.exit(1);
        }
        String outputPath = null;
        File outputFile = null;
        if (this._output == null) {
            ContentType[] providers;
            JFileChooser fc = new JFileChooser();
            fc.setDialogType(1);
            fc.setDialogTitle("Lizzy");
            fc.setFileHidingEnabled(true);
            fc.setFileSelectionMode(0);
            fc.setMultiSelectionEnabled(false);
            fc.setApproveButtonText("Save playlist");
            fc.setAcceptAllFileFilterUsed(true);
            if (provider == null) {
                ContentTypesFileFilter allFilter = new ContentTypesFileFilter("All Playlists", false);
                providers = SpecificPlaylistFactory.getInstance().getProviders();
                for (SpecificPlaylistProvider specificPlaylistProvider : providers) {
                    ContentTypesFileFilter providerFilter = new ContentTypesFileFilter("All " + specificPlaylistProvider.getId() + "-like", true);
                    providerFilter.setProvider(specificPlaylistProvider);
                    for (ContentType type : specificPlaylistProvider.getContentTypes()) {
                        ContentTypesFileFilter typeFilter = new ContentTypesFileFilter(type.getDescription(), true);
                        typeFilter.setProvider(specificPlaylistProvider);
                        fc.setFileFilter(typeFilter);
                        typeFilter.addContentType(type);
                        providerFilter.addContentType(type);
                        allFilter.addContentType(type);
                    }
                    if (providerFilter.getContentTypes().size() <= 1) continue;
                    fc.setFileFilter(providerFilter);
                }
                if (allFilter.getContentTypes().size() > 1) {
                    fc.setFileFilter(allFilter);
                }
            } else {
                void var9_14;
                ContentTypesFileFilter providerFilter = new ContentTypesFileFilter("All " + provider.getId() + "-like", true);
                providerFilter.setProvider(provider);
                providers = provider.getContentTypes();
                int n = providers.length;
                boolean bl = false;
                while (var9_14 < n) {
                    ContentType type = providers[var9_14];
                    ContentTypesFileFilter typeFilter = new ContentTypesFileFilter(type.getDescription(), true);
                    typeFilter.setProvider(provider);
                    fc.setFileFilter(typeFilter);
                    typeFilter.addContentType(type);
                    providerFilter.addContentType(type);
                    ++var9_14;
                }
                if (providerFilter.getContentTypes().size() > 1) {
                    fc.setFileFilter(providerFilter);
                }
            }
            String userDir = System.getProperty("user.dir");
            if (userDir != null) {
                fc.setCurrentDirectory(new File(userDir));
            }
            if (fc.showDialog(null, null) != 0) {
                System.exit(2);
            }
            outputFile = fc.getSelectedFile();
            outputUrl = outputFile.toURI().toURL();
            outputPath = outputFile.getName();
            if (provider == null) {
                ContentTypesFileFilter f = (ContentTypesFileFilter)fc.getFileFilter();
                provider = f.getProvider();
            }
        } else {
            try {
                outputUrl = new URL(this._output);
                outputPath = outputUrl.getPath();
                if ("file".equals(outputUrl.getProtocol())) {
                    URI uri = outputUrl.toURI();
                    outputFile = new File(uri);
                }
            }
            catch (MalformedURLException e) {
                outputFile = new File(this._output);
                outputUrl = outputFile.toURI().toURL();
            }
        }
        if (outputFile != null) {
            outputFile = outputFile.getCanonicalFile();
        }
        if (provider == null) {
            if (outputPath == null) {
                outputPath = this._output;
            }
            if ((provider = SpecificPlaylistFactory.getInstance().findProviderByExtension(outputPath)) == null) {
                System.err.println("Unknown type of specific playlist <" + this._output + '>');
                System.exit(1);
            }
        }
        Playlist playlist = new Playlist();
        try {
            SpecificPlaylist inputSpecificPlaylist = SpecificPlaylistFactory.getInstance().readFrom(outputUrl);
            if (inputSpecificPlaylist == null) {
                System.err.println("ERROR: Invalid playlist format from URL <" + outputUrl + '>');
            } else {
                playlist = inputSpecificPlaylist.toPlaylist();
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("WARNING: Cannot fetch URL <" + outputUrl + '>' + e);
        }
        catch (Exception e) {
            System.err.println("ERROR: Cannot read playlist from URL <" + outputUrl + '>' + e);
        }
        for (String arg : this._arguments) {
            File file = new File(arg);
            if (file.exists()) {
                this.addToPlaylist(playlist.getRootSequence(), file, true, outputFile);
                continue;
            }
            Media media = new Media();
            Content content = new Content(arg);
            media.setSource(content);
            playlist.getRootSequence().addComponent(media);
        }
        playlist.normalize();
        FetchContentMetadata metadataVisitor = new FetchContentMetadata();
        metadataVisitor.setConnect(this._fetchContentMetadata);
        playlist.acceptDown(metadataVisitor);
        if (provider instanceof RSSProvider) {
            ((RSSProvider)provider).setUseRSSMedia(this._useRSSMedia);
        }
        if ((outputSpecificPlaylist = provider.toSpecificPlaylist(playlist)) instanceof M3U) {
            ((M3U)outputSpecificPlaylist).setExtensionM3U(this._extM3U);
        }
        if (outputSpecificPlaylist instanceof PLP && this._diskSpecifier != null) {
            ((PLP)outputSpecificPlaylist).setDiskSpecifier(this._diskSpecifier);
        }
        if (outputFile == null) {
            URLConnection uRLConnection = outputUrl.openConnection();
            uRLConnection.setAllowUserInteraction(true);
            uRLConnection.setDoInput(false);
            uRLConnection.setDoOutput(true);
            uRLConnection.connect();
            out = uRLConnection.getOutputStream();
        } else {
            out = new FileOutputStream(outputFile);
        }
        outputSpecificPlaylist.writeTo(out, null);
        out.flush();
        ((OutputStream)out).close();
    }

    private void addToPlaylist(Sequence sequence, File file, boolean recurse, File playlistFile) throws IOException {
        if (file.isDirectory()) {
            File[] files;
            if (recurse && (files = file.listFiles()) != null) {
                for (File child : files) {
                    this.addToPlaylist(sequence, child, this._recursive, playlistFile);
                }
            }
        } else if (file.isFile()) {
            boolean include = true;
            String filePath = file.getPath();
            if (playlistFile != null) {
                File canonicalFile = file.getCanonicalFile();
                if (canonicalFile.equals(playlistFile)) {
                    include = false;
                } else {
                    File playlistParentFile;
                    File parentFile = canonicalFile.getParentFile();
                    if (parentFile.equals(playlistParentFile = playlistFile.getParentFile())) {
                        filePath = file.getName();
                    } else {
                        StringBuilder sb = new StringBuilder(file.getName());
                        File previousFile = parentFile;
                        parentFile = previousFile.getParentFile();
                        while (parentFile != null) {
                            sb.insert(0, '/');
                            String previousFileName = previousFile.getName();
                            if (!"/".equals(previousFileName) && !"\\".equals(previousFileName)) {
                                sb.insert(0, previousFileName);
                            }
                            if (parentFile.equals(playlistParentFile)) {
                                filePath = sb.toString();
                                break;
                            }
                            previousFile = parentFile;
                            parentFile = previousFile.getParentFile();
                        }
                    }
                }
            }
            if (include) {
                Media media = new Media();
                Content content = new Content(filePath);
                media.setSource(content);
                sequence.addComponent(media);
            }
        }
    }
}

