/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.lizzy;

import christophedelory.content.ContentMetadataCenter;
import christophedelory.content.type.ContentType;
import christophedelory.content.type.ContentTypeFactory;
import christophedelory.playlist.BasePlaylistVisitor;
import christophedelory.playlist.Media;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FetchContentMetadata
extends BasePlaylistVisitor {
    private final Log _logger = LogFactory.getLog(this.getClass());
    private boolean _connect = false;

    public void setConnect(boolean connect) {
        this._connect = connect;
    }

    @Override
    public void beginVisitMedia(Media target) throws Exception {
        if (target.getSource() != null) {
            if (this._connect) {
                try {
                    target.getSource().connect();
                }
                catch (Exception e) {
                    this._logger.warn((Object)("Cannot access media content " + target.getSource()), (Throwable)e);
                }
                ContentMetadataCenter.getInstance().fillMetadata(target.getSource());
            }
            try {
                ContentType contentType = ContentTypeFactory.getInstance().getContentType(target.getSource().getURI());
                if (contentType != null) {
                    target.getSource().setType(contentType.getMimeTypes()[0]);
                }
            }
            catch (Exception e) {
                this._logger.warn((Object)("Cannot build URI for media content " + target.getSource()), (Throwable)e);
            }
        }
    }
}

