/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.lizzy;

import christophedelory.content.Content;
import christophedelory.playlist.BasePlaylistVisitor;
import christophedelory.playlist.Media;
import christophedelory.playlist.Parallel;
import christophedelory.playlist.Sequence;

public class PlaylistToString
extends BasePlaylistVisitor {
    private final StringBuilder _sb = new StringBuilder();
    private int _indent = 0;
    private boolean _debug = false;

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public String toString() {
        return this._sb.toString();
    }

    @Override
    public void beginVisitParallel(Parallel target) throws Exception {
        this.addIndent();
        this._sb.append("PARALLEL(x");
        this._sb.append(target.getRepeatCount());
        if (this._debug) {
            this._sb.append(", parent=");
            this._sb.append(target.getParent() != null);
        }
        this._sb.append(")\n");
        this._indent += 2;
    }

    @Override
    public void endVisitParallel(Parallel target) throws Exception {
        this._indent -= 2;
    }

    @Override
    public void beginVisitSequence(Sequence target) throws Exception {
        this.addIndent();
        this._sb.append("SEQUENCE(x");
        this._sb.append(target.getRepeatCount());
        if (this._debug) {
            this._sb.append(", parent=");
            this._sb.append(target.getParent() != null);
        }
        this._sb.append(")\n");
        this._indent += 2;
    }

    @Override
    public void endVisitSequence(Sequence target) throws Exception {
        this._indent -= 2;
    }

    @Override
    public void beginVisitMedia(Media target) throws Exception {
        this.addIndent();
        this._sb.append("MEDIA(x");
        this._sb.append(target.getRepeatCount());
        if (target.getDuration() != null) {
            this._sb.append(", ");
            this._sb.append(target.getDuration());
            this._sb.append("ms");
        }
        if (this._debug) {
            this._sb.append(", parent=");
            this._sb.append(target.getParent() != null);
        }
        this._sb.append(')');
        Content content = target.getSource();
        if (content != null) {
            this._sb.append(": ");
            this._sb.append(content);
            this._sb.append(" [length=");
            this._sb.append(content.getLength());
            this._sb.append(" bytes");
            if (content.getDuration() >= 0L) {
                this._sb.append(", duration=");
                this._sb.append(content.getDuration());
                this._sb.append("ms");
            }
            if (content.getWidth() >= 0 && content.getHeight() >= 0) {
                this._sb.append(", ");
                this._sb.append(content.getWidth());
                this._sb.append('x');
                this._sb.append(content.getHeight());
            }
            if (content.getType() != null) {
                this._sb.append(", type=");
                this._sb.append(content.getType());
            }
            if (content.getEncoding() != null) {
                this._sb.append(", encoding=");
                this._sb.append(content.getEncoding());
            }
            this._sb.append(']');
        }
        this._sb.append('\n');
    }

    private void addIndent() {
        for (int i = 0; i < this._indent; ++i) {
            this._sb.append(' ');
        }
    }
}

