/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.lizzy;

import christophedelory.lizzy.FetchContentMetadata;
import christophedelory.lizzy.PlaylistToString;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistFactory;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.m3u.M3U;
import christophedelory.playlist.plp.PLP;
import christophedelory.playlist.rss.RSSProvider;
import christophedelory.xml.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class Transcode {
    @Option(name="-t", usage="The output playlist type\nAllowed values: see below\nIf missing, the input playlist type is used", metaVar="type")
    private volatile String _type = null;
    @Option(name="-g", usage="Show the intermediate generic playlist")
    private volatile boolean _showGenericPlaylist = false;
    @Option(name="-i", usage="Show the parsed input playlist")
    private volatile boolean _showInputPlaylist = false;
    @Option(name="-m", usage="Fetch if possible the media content metadata")
    private volatile boolean _fetchContentMetadata = false;
    @Option(name="-o", usage="The output file or URL\nIf missing, stdout is used\nIf the output playlist type is not specified (-t), it will be inferred from the output file name extension", metaVar="file/URL")
    private volatile String _output = null;
    @Option(name="-m3u:ext", usage="The output M3U playlist must use the Extension M3U format")
    private volatile boolean _extM3U = false;
    @Option(name="-rss:media", usage="The output RSS playlist must use the RSS Media format")
    private volatile boolean _useRSSMedia = false;
    @Option(name="-plp:disk", usage="The disk identifier of the output PLP playlist\nExamples: HARP, HDD", metaVar="disk")
    private volatile String _diskSpecifier = null;
    @Argument(usage="The input playlist file or URL", metaVar="input-playlist", required=true)
    private volatile ArrayList<String> _arguments = new ArrayList();

    public static void buildCurrentVersion(String resourceName) throws Exception {
        URL url = Version.class.getClassLoader().getResource(resourceName);
        if (url != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            String version = reader.readLine();
            Version.CURRENT = Version.valueOf(version);
        } else {
            Version.CURRENT = Version.valueOf("0.0.0");
        }
    }

    public static void main(String[] args) throws Exception {
        Transcode.buildCurrentVersion("christophedelory/lizzy/VERSION");
        System.err.println("*** Lizzy Transcode v" + Version.CURRENT);
        System.err.println("*** Copyright (c) 2008-2009, Christophe Delory");
        Transcode program = new Transcode();
        CmdLineParser parser = new CmdLineParser((Object)program);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println();
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println("Converts an input playlist to a (possibly new) format");
            System.err.println("usage: Transcode [options] <input-playlist>");
            parser.printUsage((OutputStream)System.err);
            System.err.println("Supported playlist provider types: " + program.getSupportedProviderIds());
            System.exit(1);
        }
        program.run();
    }

    private Transcode() {
    }

    public String getSupportedProviderIds() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (SpecificPlaylistProvider provider : SpecificPlaylistFactory.getInstance().getProviders()) {
            if (!first) {
                sb.append('/');
            }
            first = false;
            sb.append(provider.getId());
        }
        return sb.toString();
    }

    private void run() throws Exception {
        SpecificPlaylist outputSpecificPlaylist;
        SpecificPlaylistProvider tmpProvider;
        URL url;
        SpecificPlaylistProvider provider = null;
        if (this._type != null && (provider = SpecificPlaylistFactory.getInstance().findProviderById(this._type)) == null) {
            System.err.println("Unknown specific playlist type <" + this._type + '>');
            System.exit(1);
        }
        OutputStream out = null;
        if (this._output != null) {
            String path = null;
            try {
                URL url2 = new URL(this._output);
                path = url2.getPath();
                URLConnection conn = url2.openConnection();
                conn.setAllowUserInteraction(true);
                conn.setDoInput(false);
                conn.setDoOutput(true);
                conn.connect();
                out = conn.getOutputStream();
            }
            catch (MalformedURLException e) {
                File file = new File(this._output);
                out = new FileOutputStream(file);
            }
            if (provider == null) {
                if (path == null) {
                    path = this._output;
                }
                if ((provider = SpecificPlaylistFactory.getInstance().findProviderByExtension(path)) == null) {
                    System.err.println("Unknown type of specific playlist <" + this._output + '>');
                    System.exit(1);
                }
            }
        }
        FetchContentMetadata metadataVisitor = new FetchContentMetadata();
        metadataVisitor.setConnect(this._fetchContentMetadata);
        if (this._arguments.size() > 1) {
            System.err.println("Multiple input playlists specified. Only the first one is analyzed.");
        }
        String arg = this._arguments.get(0);
        try {
            url = new URL(arg);
        }
        catch (MalformedURLException e) {
            File file = new File(arg);
            url = file.toURI().toURL();
        }
        SpecificPlaylist inputSpecificPlaylist = SpecificPlaylistFactory.getInstance().readFrom(url);
        if (inputSpecificPlaylist == null) {
            System.err.println("Invalid playlist format from URL <" + url + '>');
            System.exit(2);
        }
        if (this._showInputPlaylist) {
            System.err.println("Input playlist " + inputSpecificPlaylist);
            inputSpecificPlaylist.writeTo(System.err, null);
            System.err.println();
        }
        Playlist playlist = inputSpecificPlaylist.toPlaylist();
        playlist.acceptDown(metadataVisitor);
        if (this._showGenericPlaylist) {
            System.err.println("Intermediate generic playlist:");
            PlaylistToString visitor = new PlaylistToString();
            playlist.acceptDown(visitor);
            System.err.println(visitor);
            System.err.println();
        }
        if ((tmpProvider = provider) == null) {
            tmpProvider = inputSpecificPlaylist.getProvider();
        }
        if (tmpProvider instanceof RSSProvider) {
            ((RSSProvider)tmpProvider).setUseRSSMedia(this._useRSSMedia);
        }
        if ((outputSpecificPlaylist = tmpProvider.toSpecificPlaylist(playlist)) instanceof M3U) {
            ((M3U)outputSpecificPlaylist).setExtensionM3U(this._extM3U);
        }
        if (outputSpecificPlaylist instanceof PLP && this._diskSpecifier != null) {
            ((PLP)outputSpecificPlaylist).setDiskSpecifier(this._diskSpecifier);
        }
        System.err.println("Output playlist " + outputSpecificPlaylist);
        OutputStream tmpOut = out;
        if (tmpOut == null) {
            tmpOut = System.out;
        }
        outputSpecificPlaylist.writeTo(tmpOut, null);
        tmpOut.flush();
        if (out != null) {
            out.close();
        }
    }
}

