/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist;

import christophedelory.content.Content;
import christophedelory.playlist.AbstractPlaylistComponent;
import christophedelory.playlist.PlaylistVisitor;

public class Media
extends AbstractPlaylistComponent {
    private Content _source = null;
    private Long _duration = null;

    public Content getSource() {
        return this._source;
    }

    public void setSource(Content source) {
        if (source == null) {
            throw new NullPointerException("No media source");
        }
        this._source = source;
    }

    public Long getDuration() {
        return this._duration;
    }

    public void setDuration(Long millis) {
        if (millis != null && millis <= 0L) {
            throw new IllegalArgumentException("Negative or null duration " + millis);
        }
        this._duration = millis;
    }

    public void setDuration(long millis) {
        if (millis <= 0L) {
            throw new IllegalArgumentException("Negative or null duration " + millis);
        }
        this._duration = millis;
    }

    @Override
    public void acceptDown(PlaylistVisitor visitor) throws Exception {
        visitor.beginVisitMedia(this);
        visitor.endVisitMedia(this);
    }

    @Override
    public void acceptUp(PlaylistVisitor visitor) throws Exception {
        visitor.beginVisitMedia(this);
        super.acceptUp(visitor);
        visitor.endVisitMedia(this);
    }
}

