/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist;

import christophedelory.content.type.ContentType;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SpecificPlaylistFactory {
    private static SpecificPlaylistFactory _instance = null;
    private final ServiceLoader<SpecificPlaylistProvider> _serviceLoader;
    private final Log _logger = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpecificPlaylistFactory getInstance() {
        Class<SpecificPlaylistFactory> clazz = SpecificPlaylistFactory.class;
        synchronized (SpecificPlaylistFactory.class) {
            if (_instance == null) {
                _instance = new SpecificPlaylistFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private SpecificPlaylistFactory() {
        this._serviceLoader = ServiceLoader.load(SpecificPlaylistProvider.class);
    }

    public void reloadProviders() {
        this._serviceLoader.reload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpecificPlaylist readFrom(URL url) throws IOException {
        SpecificPlaylist ret = null;
        for (SpecificPlaylistProvider service : this._serviceLoader) {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(false);
            urlConnection.setReadTimeout(60000);
            urlConnection.setUseCaches(true);
            urlConnection.connect();
            String contentEncoding = urlConnection.getContentEncoding();
            try (InputStream in = urlConnection.getInputStream();){
                ret = service.readFrom(in, contentEncoding, this._logger);
                break;
            }
        }
        return ret;
    }

    public SpecificPlaylist readFrom(File file) throws IOException {
        return this.readFrom(file.toURI().toURL());
    }

    public SpecificPlaylistProvider findProviderById(String id) {
        SpecificPlaylistProvider ret = null;
        for (SpecificPlaylistProvider service : this._serviceLoader) {
            if (!id.equalsIgnoreCase(service.getId())) continue;
            ret = service;
            break;
        }
        return ret;
    }

    public SpecificPlaylistProvider findProviderByExtension(String filename) {
        SpecificPlaylistProvider ret = null;
        String name = filename.toLowerCase(Locale.ENGLISH);
        for (SpecificPlaylistProvider service : this._serviceLoader) {
            ContentType[] types;
            for (ContentType type : types = service.getContentTypes()) {
                if (!type.matchExtension(name)) continue;
                ret = service;
                break;
            }
            if (ret == null) continue;
            break;
        }
        return ret;
    }

    public List<SpecificPlaylistProvider> getProviders() {
        ArrayList<SpecificPlaylistProvider> ret = new ArrayList<SpecificPlaylistProvider>();
        for (SpecificPlaylistProvider service : this._serviceLoader) {
            ret.add(service);
        }
        return ret;
    }
}

