/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.asx;

import christophedelory.content.Content;
import christophedelory.lang.StringUtils;
import christophedelory.playlist.Media;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.asx.AsxElement;
import christophedelory.playlist.asx.AsxElementContainer;
import christophedelory.playlist.asx.AsxOrEntryElement;
import christophedelory.playlist.asx.Duration;
import christophedelory.playlist.asx.Entry;
import christophedelory.playlist.asx.Entryref;
import christophedelory.playlist.asx.Reference;
import christophedelory.playlist.asx.Repeat;
import christophedelory.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class Asx
extends AsxOrEntryElement
implements SpecificPlaylist,
AsxElementContainer {
    private transient SpecificPlaylistProvider _provider = null;
    private String _version = "3.0";
    private boolean _previewMode = false;
    private String _bannerBar = null;
    private final List<AsxElement> _asxElements = new ArrayList<AsxElement>();

    @Override
    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/playlist/asx");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this, writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (AsxElement asxElement : this._asxElements) {
            this.addToSequence(asxElement, ret.getRootSequence());
        }
        ret.normalize();
        return ret;
    }

    private void addToSequence(AsxElement asxElement, Sequence currentSequence) {
        Entryref entryRef;
        if (asxElement instanceof Repeat) {
            Repeat repeat = (Repeat)asxElement;
            Sequence seq = new Sequence();
            seq.setRepeatCount(repeat.getCount() == null ? -1 : repeat.getCount() + 1);
            currentSequence.addComponent(seq);
            for (AsxElement asxElem : repeat.getAsxElements()) {
                this.addToSequence(asxElem, seq);
            }
        } else if (asxElement instanceof Entry) {
            Entry entry = (Entry)asxElement;
            for (Reference reference : entry.getReferences()) {
                if (reference.getHref() == null) continue;
                Duration duration = reference.getDuration();
                if (duration == null) {
                    duration = entry.getDuration();
                }
                if (duration != null && duration.getValue() <= 0L) continue;
                Media media = new Media();
                media.setSource(new Content(reference.getHref()));
                if (duration != null) {
                    media.setDuration(duration.getValue());
                }
                currentSequence.addComponent(media);
                break;
            }
        } else if (asxElement instanceof Entryref && (entryRef = (Entryref)asxElement).getHref() != null) {
            Media media = new Media();
            media.setSource(new Content(entryRef.getHref()));
            currentSequence.addComponent(media);
        }
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version.trim();
    }

    public String getBannerBar() {
        return this._bannerBar;
    }

    public void setBannerBar(String bannerBar) {
        String banner = StringUtils.normalize(bannerBar);
        this._bannerBar = "FIXED".equalsIgnoreCase(banner) ? "FIXED" : null;
    }

    public String getPreviewModeString() {
        String ret = null;
        if (this._previewMode) {
            ret = "YES";
        }
        return ret;
    }

    public void setPreviewModeString(String previewMode) {
        String preview = StringUtils.normalize(previewMode);
        this._previewMode = "YES".equalsIgnoreCase(preview);
    }

    public boolean isPreviewMode() {
        return this._previewMode;
    }

    public void setPreviewMode(boolean previewMode) {
        this._previewMode = previewMode;
    }

    @Override
    public void addAsxElement(AsxElement asxElement) {
        if (asxElement instanceof Asx) {
            throw new IllegalStateException("Element not valid here: " + asxElement);
        }
        asxElement.setParent(this);
        this._asxElements.add(asxElement);
    }

    @Override
    public List<AsxElement> getAsxElements() {
        return this._asxElements;
    }
}

