/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.asx;

import christophedelory.lang.StringUtils;
import christophedelory.playlist.asx.Child;

public class Duration
extends Child {
    private long _value = 0L;

    public String getValueString() {
        StringBuilder sb = new StringBuilder();
        long millis = this._value;
        long i = millis / 3600000L;
        sb.append(StringUtils.toString(i, 2));
        sb.append(':');
        millis -= i * 60L * 60L * 1000L;
        i = millis / 60000L;
        sb.append(StringUtils.toString(i, 2));
        sb.append(':');
        millis -= i * 60L * 1000L;
        i = millis / 1000L;
        sb.append(StringUtils.toString(i, 2));
        if ((millis -= i * 1000L) > 0L) {
            sb.append('.');
            sb.append(StringUtils.toString(millis, 3));
        }
        return sb.toString();
    }

    public void setValueString(String value) {
        String[] array = value.trim().split(":");
        if (array.length != 3) {
            throw new IllegalArgumentException("Invalid duration format " + value);
        }
        long hours = Long.parseLong(array[0]);
        if (hours < 0L) {
            throw new IllegalArgumentException("Negative hours");
        }
        long minutes = Long.parseLong(array[1]);
        if (minutes < 0L || minutes > 59L) {
            throw new IllegalArgumentException("Invalid minutes");
        }
        String[] subArray = array[2].split("\\.");
        if (subArray.length > 2) {
            throw new IllegalArgumentException("Invalid duration format " + value);
        }
        long seconds = Long.parseLong(subArray[0]);
        if (seconds < 0L || seconds > 59L) {
            throw new IllegalArgumentException("Invalid seconds");
        }
        long millis = 0L;
        if (subArray.length > 1) {
            StringBuilder sb = new StringBuilder(subArray[1]);
            switch (sb.length()) {
                case 1: {
                    sb.append("00");
                    break;
                }
                case 2: {
                    sb.append('0');
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    sb.delete(3, sb.length());
                }
            }
            millis = Long.parseLong(sb.toString());
            if (millis < 0L) {
                throw new IllegalArgumentException("Negative milliseconds");
            }
        }
        this.setValue(hours * 60L * 60L * 1000L + minutes * 60L * 1000L + seconds * 1000L + millis);
    }

    public void setValue(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Negative milliseconds duration " + millis);
        }
        this._value = millis;
    }

    public long getValue() {
        return this._value;
    }
}

