/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.atom;

import christophedelory.atom.Entry;
import christophedelory.atom.Feed;
import christophedelory.atom.Link;
import christophedelory.content.Content;
import christophedelory.playlist.Media;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;

public class AtomPlaylist
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private Feed _feed = new Feed();

    @Override
    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/atom");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this._feed, writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (Entry entry : this._feed.getEntries()) {
            for (Link link : entry.getLinks()) {
                if (link.getHref() == null || !"enclosure".equals(link.getRel())) continue;
                Media media = new Media();
                Content content = new Content(link.getHref());
                content.setType(link.getType());
                if (link.getLength() != null) {
                    content.setLength(link.getLength());
                }
                media.setSource(content);
                ret.getRootSequence().addComponent(media);
            }
        }
        ret.normalize();
        return ret;
    }

    public Feed getFeed() {
        return this._feed;
    }

    public void setFeed(Feed feed) {
        if (feed == null) {
            throw new NullPointerException("No Atom Feed Document");
        }
        this._feed = feed;
    }
}

