/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.b4s;

import christophedelory.content.type.ContentType;
import christophedelory.io.IOUtils;
import christophedelory.player.PlayerSupport;
import christophedelory.playlist.AbstractPlaylistComponent;
import christophedelory.playlist.Media;
import christophedelory.playlist.Parallel;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.b4s.Entry;
import christophedelory.playlist.b4s.Playlist;
import christophedelory.playlist.b4s.WinampXML;
import christophedelory.xml.XmlSerializer;
import java.io.InputStream;
import java.io.StringReader;
import org.apache.commons.logging.Log;

public class B4sProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".b4s", ".bpl"}, new String[]{"text/xml"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINAMP, false, null), new PlayerSupport(PlayerSupport.Player.VLC_MEDIA_PLAYER, false, null)}, "Winamp 3+ Playlist")};

    @Override
    public String getId() {
        return "b4s";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        String str = IOUtils.toString(in, enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/playlist/b4s");
        serializer.getUnmarshaller().setIgnoreExtraElements(false);
        StringReader reader = new StringReader(str);
        SpecificPlaylist ret = (SpecificPlaylist)serializer.unmarshal(reader);
        ret.setProvider(this);
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(christophedelory.playlist.Playlist playlist) throws Exception {
        WinampXML ret = new WinampXML();
        ret.setProvider(this);
        this.addToPlaylist(ret.getPlaylist(), playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(Playlist playlist, AbstractPlaylistComponent component) throws Exception {
        block10: {
            block9: {
                if (!(component instanceof Sequence)) break block9;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A B4S playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = sequence.getComponents();
                for (int iter = 0; iter < sequence.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(playlist, c);
                    }
                }
                break block10;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A B4S playlist cannot play different media at the same time");
            }
            if (!(component instanceof Media)) break block10;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A B4S playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A B4S playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    Entry entry = new Entry();
                    entry.setPlaystring(media.getSource().toString());
                    if (media.getSource().getLength() >= 0L) {
                        entry.setLength((int)media.getSource().getLength());
                    }
                    playlist.addEntry(entry);
                }
            }
        }
    }
}

