/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.b4s;

import christophedelory.lang.StringUtils;
import christophedelory.playlist.b4s.Entry;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Playlist {
    private final List<Entry> _entries = new ArrayList<Entry>();
    private int _numEntries = -1;
    private String _label = null;

    public int getNumberOfEntries() {
        return this._entries.size();
    }

    public void setNumberOfEntries(int numEntries) {
        if (numEntries < 0) {
            throw new IllegalArgumentException("Negative number of entries");
        }
        this._numEntries = numEntries;
    }

    public String getLabel() {
        return this._label;
    }

    public void setLabel(String label) {
        this._label = StringUtils.normalize(label);
    }

    public void addEntry(Entry entry) {
        if (entry == null) {
            throw new NullPointerException("no entry");
        }
        if (this._numEntries < 0 || this._entries.size() < this._numEntries) {
            this._entries.add(entry);
        } else {
            Log logger = LogFactory.getLog(this.getClass());
            logger.warn((Object)"Ignoring extra B4S entry");
        }
    }

    public List<Entry> getEntries() {
        return this._entries;
    }
}

