/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.b4s;

import christophedelory.content.Content;
import christophedelory.playlist.Media;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.b4s.Entry;
import christophedelory.playlist.b4s.Playlist;
import christophedelory.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;

public class WinampXML
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private Playlist _playlist = new Playlist();

    @Override
    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/playlist/b4s");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this, writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    @Override
    public christophedelory.playlist.Playlist toPlaylist() {
        christophedelory.playlist.Playlist ret = new christophedelory.playlist.Playlist();
        for (Entry entry : this._playlist.getEntries()) {
            if (entry.getPlaystring() == null) continue;
            Media media = new Media();
            Content content = new Content(entry.getPlaystring());
            if (entry.getLength() != null) {
                content.setLength(entry.getLength().longValue());
            }
            media.setSource(content);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }

    public Playlist getPlaylist() {
        return this._playlist;
    }

    public void setPlaylist(Playlist playlist) {
        if (playlist == null) {
            throw new NullPointerException("no playlist");
        }
        this._playlist = playlist;
    }
}

