/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.hypetape;

import christophedelory.content.Content;
import christophedelory.playlist.Media;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.hypetape.Track;
import christophedelory.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class Playlist
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private final List<Track> _tracks = new ArrayList<Track>();

    @Override
    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/playlist/hypetape");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this, writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    @Override
    public christophedelory.playlist.Playlist toPlaylist() {
        christophedelory.playlist.Playlist ret = new christophedelory.playlist.Playlist();
        for (Track track : this._tracks) {
            if (track.getMP3() == null) continue;
            Media media = new Media();
            Content content = new Content(track.getMP3());
            media.setSource(content);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }

    public void addTrack(Track track) {
        if (track == null) {
            throw new NullPointerException("no track");
        }
        this._tracks.add(track);
    }

    public List<Track> getTracks() {
        return this._tracks;
    }
}

