/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.kpl;

import christophedelory.content.type.ContentType;
import christophedelory.io.IOUtils;
import christophedelory.player.PlayerSupport;
import christophedelory.playlist.AbstractPlaylistComponent;
import christophedelory.playlist.Media;
import christophedelory.playlist.Parallel;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.kpl.Entry;
import christophedelory.playlist.kpl.Tag;
import christophedelory.playlist.kpl.Xml;
import christophedelory.xml.Version;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class KplProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".kpl"}, new String[]{"text/xml"}, new PlayerSupport[0], "Kalliope PlayList")};

    @Override
    public String getId() {
        return "kpl";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        String str = IOUtils.toString(in, enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        str = str.replaceAll("<([0-9]+) ", "<x$1 ");
        str = str.replaceAll("</([0-9]+)", "</x$1");
        StringReader reader = new StringReader(str);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new DefaultHandler());
        Document document = documentBuilder.parse(new InputSource(reader));
        if (!"xml".equals(document.getDocumentElement().getTagName())) {
            throw new IllegalArgumentException("Not a Kalliope playlist (root element is not named 'xml')");
        }
        Xml ret = new Xml();
        ret.setProvider(this);
        int nb = 0;
        NodeList nodeList = document.getElementsByTagName('x' + Integer.toString(nb));
        while (nodeList.getLength() > 0) {
            Entry entry = new Entry();
            Element element = (Element)nodeList.item(0);
            entry.setFilename(element.getAttribute("filename"));
            ret.getEntries().add(entry);
            NodeList tagNodeList = element.getElementsByTagName("tag");
            if (tagNodeList.getLength() > 0) {
                Tag tag = new Tag();
                Element tagElement = (Element)tagNodeList.item(0);
                tag.setArtist(tagElement.getAttribute("artist"));
                tag.setAlbum(tagElement.getAttribute("album"));
                tag.setTitle(tagElement.getAttribute("title"));
                tag.setYear(tagElement.getAttribute("year"));
                tag.setComment(tagElement.getAttribute("comment"));
                tag.setGenre(tagElement.getAttribute("genre"));
                tag.setTrack(tagElement.getAttribute("track"));
                tag.setGid(tagElement.getAttribute("gid"));
                tag.setHasTag(tagElement.getAttribute("has_tag"));
                entry.setTag(tag);
            }
            nodeList = document.getElementsByTagName('x' + Integer.toString(++nb));
        }
        nodeList = document.getElementsByTagName("info");
        if (nodeList.getLength() > 0) {
            Element infoElement = (Element)nodeList.item(0);
            ret.getInfo().setCreationDayString(infoElement.getAttribute("creation_day"));
            ret.getInfo().setModifiedDayString(infoElement.getAttribute("modified_day"));
            ret.getInfo().setAuthor(infoElement.getAttribute("author"));
            ret.getInfo().setPlayer(infoElement.getAttribute("player"));
            ret.getInfo().setPlayerVersion(infoElement.getAttribute("player_version"));
            ret.getInfo().setKplVersion(infoElement.getAttribute("kpl_version"));
        }
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        Xml ret = new Xml();
        ret.setProvider(this);
        Date day = new Date();
        ret.getInfo().setCreationDay(day);
        ret.getInfo().setModifiedDay(day);
        ret.getInfo().setAuthor("Lizzy v" + Version.CURRENT);
        this.addToPlaylist(ret.getEntries(), playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(List<Entry> entries, AbstractPlaylistComponent component) throws Exception {
        block9: {
            block8: {
                if (!(component instanceof Sequence)) break block8;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A KPL playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = sequence.getComponents();
                for (int iter = 0; iter < sequence.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(entries, c);
                    }
                }
                break block9;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A KPL playlist cannot play different media at the same time");
            }
            if (!(component instanceof Media)) break block9;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A KPL playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A KPL playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    Entry entry = new Entry();
                    entry.setFilename(media.getSource().toString());
                    entries.add(entry);
                    Tag tag = new Tag();
                    tag.setGid(Integer.toString(System.identityHashCode(entry)));
                    tag.setGenre("Other");
                    tag.setYear("Unknown Year");
                    tag.setTitle(media.getSource().toString());
                    entry.setTag(tag);
                }
            }
        }
    }
}

