/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.mpcpl;

import christophedelory.content.type.ContentType;
import christophedelory.player.PlayerSupport;
import christophedelory.playlist.AbstractPlaylistComponent;
import christophedelory.playlist.Media;
import christophedelory.playlist.Parallel;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.mpcpl.MPCPL;
import christophedelory.playlist.mpcpl.Resource;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.commons.logging.Log;

public class MPCPLProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".mpcpl"}, new String[]{"text/plain"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, true, null)}, "Media Player Classic Playlist")};

    @Override
    public String getId() {
        return "mpcpl";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String line;
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, enc));
        MPCPL ret = new MPCPL();
        ret.setProvider(this);
        boolean magicFound = false;
        while ((line = reader.readLine()) != null) {
            int resourceIndex;
            if ((line = line.trim()).length() <= 0) continue;
            if (!magicFound) {
                if (!line.equalsIgnoreCase("MPCPLAYLIST")) {
                    throw new IllegalArgumentException("Not a MPCPL playlist format");
                }
                magicFound = true;
                continue;
            }
            int idx = line.indexOf(44);
            if (idx <= 0) {
                logger.error((Object)("Malformed MPCPL playlist entry " + line));
                ret = null;
                break;
            }
            String resourceIndexString = line.substring(0, idx).trim();
            if ((idx = (line = line.substring(idx + 1)).indexOf(44)) <= 0) {
                logger.error((Object)("Malformed MPCPL playlist entry " + line));
                ret = null;
                break;
            }
            String key = line.substring(0, idx).trim().toLowerCase();
            String value = line.substring(idx + 1).trim();
            try {
                resourceIndex = Integer.parseInt(resourceIndexString) - 1;
            }
            catch (NumberFormatException e) {
                logger.error((Object)e.toString());
                ret = null;
                break;
            }
            for (int i = ret.getResources().size(); i < resourceIndex + 1; ++i) {
                ret.getResources().add(new Resource());
            }
            Resource resource = ret.getResources().get(resourceIndex);
            if ("filename".equals(key)) {
                resource.setFilename(value);
                continue;
            }
            if ("type".equals(key)) {
                resource.setType(value);
                continue;
            }
            if ("subtitle".equals(key)) {
                resource.setSubtitle(value);
                continue;
            }
            logger.warn((Object)("Unknown MPCPL keyword " + key));
        }
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        MPCPL ret = new MPCPL();
        ret.setProvider(this);
        this.addToPlaylist(ret.getResources(), playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(List<Resource> resources, AbstractPlaylistComponent component) throws Exception {
        block9: {
            block8: {
                if (!(component instanceof Sequence)) break block8;
                Sequence seq = (Sequence)component;
                if (seq.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A MPCPL playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = seq.getComponents();
                for (int iter = 0; iter < seq.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(resources, c);
                    }
                }
                break block9;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A parallel time container is incompatible with a MPCPL playlist");
            }
            if (!(component instanceof Media)) break block9;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A MPCPL playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A MPCPL playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    Resource resource = new Resource();
                    resource.setFilename(media.getSource().toString());
                    resources.add(resource);
                }
            }
        }
    }
}

