/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.pla;

import christophedelory.content.type.ContentType;
import christophedelory.player.PlayerSupport;
import christophedelory.playlist.AbstractPlaylistComponent;
import christophedelory.playlist.Media;
import christophedelory.playlist.Parallel;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.pla.PLA;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.logging.Log;

public class PLAProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".pla"}, new String[]{"application/octet-stream"}, new PlayerSupport[0], "iRiver iQuickList File")};

    @Override
    public String getId() {
        return "pla";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        PLA ret = new PLA();
        ret.setProvider(this);
        byte[] array = new byte[512];
        if (in.read(array) != 512) {
            throw new IllegalArgumentException("Not a PLA playlist format (file too small)");
        }
        String magic = new String(array, 4, 14, "US-ASCII");
        if (!"iriver UMS PLA".equals(magic)) {
            throw new IllegalArgumentException("Not a PLA playlist format (bad magic)");
        }
        int nbSongs = (array[3] & 0xFF) << 0 | (array[2] & 0xFF) << 8 | (array[1] & 0xFF) << 16 | (array[0] & 0xFF) << 24;
        for (int i = 0; i < nbSongs; ++i) {
            if (in.read(array) != 512) {
                logger.error((Object)"Malformed PLA playlist (file too small)");
                ret = null;
                break;
            }
            String songFilename = new String(array, 2, 510, "UTF-16BE");
            ret.getFilenames().add(songFilename);
        }
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        PLA ret = new PLA();
        ret.setProvider(this);
        this.addToPlaylist(ret.getFilenames(), playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(List<String> filenames, AbstractPlaylistComponent component) throws Exception {
        block9: {
            block8: {
                if (!(component instanceof Sequence)) break block8;
                Sequence seq = (Sequence)component;
                if (seq.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A PLA playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = seq.getComponents();
                for (int iter = 0; iter < seq.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(filenames, c);
                    }
                }
                break block9;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A parallel time container is incompatible with a PLA playlist");
            }
            if (!(component instanceof Media)) break block9;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A PLA playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A PLA playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    filenames.add(media.getSource().toString());
                }
            }
        }
    }
}

