/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.plist;

import christophedelory.content.Content;
import christophedelory.playlist.Media;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.plist.Array;
import christophedelory.plist.Dict;
import christophedelory.plist.Integer;
import christophedelory.plist.Plist;
import christophedelory.plist.PlistObject;
import christophedelory.plist.PlistText;
import christophedelory.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Date;

public class PlistPlaylist
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private Plist _plist = new Plist();

    @Override
    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/plist");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this._plist, writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        if (this._plist.getPlistObject() != null && this._plist.getPlistObject() instanceof Dict) {
            Dict rootDict = (Dict)this._plist.getPlistObject();
            Dict tracks = null;
            PlistObject tracksObject = rootDict.findObjectByKey("Tracks");
            if (tracksObject != null && tracksObject instanceof Dict) {
                tracks = (Dict)tracksObject;
            }
            Array playlists = null;
            PlistObject playlistsObject = rootDict.findObjectByKey("Playlists");
            if (playlistsObject != null && playlistsObject instanceof Array) {
                playlists = (Array)playlistsObject;
            }
            if (tracks != null && playlists != null) {
                for (PlistObject playlistObject : playlists.getPlistObjects()) {
                    Dict playlist;
                    PlistObject playlistItemsArrayObject;
                    if (!(playlistObject instanceof Dict) || (playlistItemsArrayObject = (playlist = (Dict)playlistObject).findObjectByKey("Playlist Items")) == null || !(playlistItemsArrayObject instanceof Array)) continue;
                    Array playlistItemsArray = (Array)playlistItemsArrayObject;
                    Sequence sequence = new Sequence();
                    for (PlistObject playlistItemsDictObject : playlistItemsArray.getPlistObjects()) {
                        Date dateModified;
                        PlistObject dateModifiedObject;
                        String sizeString;
                        PlistObject sizeObject;
                        String totalTimeString;
                        String location;
                        Dict track;
                        PlistObject locationObject;
                        PlistObject trackObject;
                        String trackId;
                        PlistObject trackIdObject;
                        if (!(playlistItemsDictObject instanceof Dict) || (trackIdObject = ((Dict)playlistItemsDictObject).findObjectByKey("Track ID")) == null || !(trackIdObject instanceof PlistText) || (trackId = ((PlistText)trackIdObject).getValue()) == null || (trackObject = tracks.findObjectByKey(trackId)) == null || !(trackObject instanceof Dict) || (locationObject = (track = (Dict)trackObject).findObjectByKey("Location")) == null || !(locationObject instanceof PlistText) || (location = ((PlistText)locationObject).getValue()) == null) continue;
                        Media media = new Media();
                        Content content = new Content(location);
                        media.setSource(content);
                        PlistObject totalTimeObject = track.findObjectByKey("Total Time");
                        if (totalTimeObject != null && totalTimeObject instanceof Integer && (totalTimeString = ((Integer)totalTimeObject).getValue()) != null) {
                            try {
                                java.lang.Integer totalTime = java.lang.Integer.decode(totalTimeString);
                                content.setDuration(totalTime.longValue());
                            }
                            catch (NumberFormatException totalTime) {
                                // empty catch block
                            }
                        }
                        if ((sizeObject = track.findObjectByKey("Size")) != null && sizeObject instanceof Integer && (sizeString = ((Integer)sizeObject).getValue()) != null) {
                            try {
                                java.lang.Integer size = java.lang.Integer.decode(sizeString);
                                if (size >= 0) {
                                    content.setLength(size.longValue());
                                }
                            }
                            catch (NumberFormatException size) {
                                // empty catch block
                            }
                        }
                        if ((dateModifiedObject = track.findObjectByKey("Date Modified")) != null && dateModifiedObject instanceof christophedelory.plist.Date && (dateModified = ((christophedelory.plist.Date)dateModifiedObject).getValue()) != null) {
                            content.setLastModified(dateModified.getTime());
                        }
                        sequence.addComponent(media);
                    }
                    ret.getRootSequence().addComponent(sequence);
                }
                ret.normalize();
            }
        }
        return ret;
    }

    public Plist getPlist() {
        return this._plist;
    }

    public void setPlist(Plist plist) {
        if (plist == null) {
            throw new NullPointerException("No plist");
        }
        this._plist = plist;
    }
}

