/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.pls;

import christophedelory.content.Content;
import christophedelory.playlist.Media;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.m3u.Resource;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class PLS
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private final List<Resource> _resources = new ArrayList<Resource>();

    @Override
    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, enc));
        writer.write("[Playlist]");
        writer.newLine();
        writer.write("NumberOfEntries=");
        writer.write(Integer.toString(this._resources.size()));
        writer.newLine();
        int i = 1;
        for (Resource resource : this._resources) {
            writer.write("File");
            writer.write(Integer.toString(i));
            writer.write("=");
            writer.write(resource.getLocation());
            writer.newLine();
            if (resource.getName() != null) {
                writer.write("Title");
                writer.write(Integer.toString(i));
                writer.write("=");
                writer.write(resource.getName());
                writer.newLine();
            }
            if (resource.getLength() >= 0L) {
                writer.write("Length");
                writer.write(Integer.toString(i));
                writer.write("=");
                writer.write(Long.toString(resource.getLength()));
                writer.newLine();
            }
            ++i;
        }
        writer.write("Version=2");
        writer.newLine();
        writer.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (Resource resource : this._resources) {
            if (resource.getLocation() == null) continue;
            Media media = new Media();
            Content content = new Content(resource.getLocation());
            media.setSource(content);
            content.setDuration(resource.getLength() * 1000L);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }

    public List<Resource> getResources() {
        return this._resources;
    }
}

