/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.rmp;

import christophedelory.content.Content;
import christophedelory.lang.StringUtils;
import christophedelory.playlist.Media;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.rmp.Provider;
import christophedelory.playlist.rmp.Server;
import christophedelory.playlist.rmp.Track;
import christophedelory.playlist.rmp.Tracklist;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="PACKAGE")
public class Package
implements SpecificPlaylist {
    private static final DateFormat DATETIME_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm", Locale.US);
    private transient SpecificPlaylistProvider _provider = null;
    private String _title = null;
    private String _action = null;
    private String _target = null;
    private Date _expirationDate = null;
    private Provider _packageProvider = null;
    private Server _server = new Server();
    private Tracklist _trackList = new Tracklist();
    private String _signature = null;

    public Package() {
        this._trackList.setParent(this);
    }

    @Override
    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    @XmlTransient
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        JAXBContext jc = JAXBContext.newInstance((String)"christophedelory.playlist.rmp");
        Marshaller marshaller = jc.createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)enc);
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.marshal((Object)this, out);
        out.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        String location = this._server.getLocation();
        location = location.replace("%lid", this._trackList.getId() == null ? "" : this._trackList.getId());
        location = location.replace("%pid", this._target == null ? "" : this._target);
        for (Track track : this._trackList.getTracks()) {
            String url = location.replace("%fid", track.getId() == null ? "" : track.getId());
            url = url.replace("%f", track.getFileName() == null ? "" : track.getFileName());
            if (this._server.getNetName() != null) {
                StringBuilder sb = new StringBuilder("http://");
                sb.append(this._server.getNetName());
                sb.append(url);
                url = sb.toString();
            }
            Media media = new Media();
            Content content = new Content(url);
            if (track.getSize() != null) {
                content.setLength(track.getSize());
            }
            if (track.getDuration() != null) {
                content.setDuration(track.getDuration().longValue() * 1000L);
            }
            media.setSource(content);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }

    @XmlElement(name="TITLE")
    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = StringUtils.normalize(title);
    }

    @XmlElement(name="ACTION")
    public String getAction() {
        return this._action;
    }

    public void setAction(String action) {
        this._action = StringUtils.normalize(action);
    }

    @XmlElement(name="TARGET")
    public String getTarget() {
        return this._target;
    }

    public void setTarget(String target) {
        this._target = StringUtils.normalize(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XmlElement(name="EXP_DATE")
    public String getExpirationDateString() {
        String ret = null;
        if (this._expirationDate != null) {
            DateFormat dateFormat = DATETIME_FORMAT;
            synchronized (dateFormat) {
                ret = DATETIME_FORMAT.format(this._expirationDate);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExpirationDateString(String expirationDate) throws ParseException {
        DateFormat dateFormat = DATETIME_FORMAT;
        synchronized (dateFormat) {
            this._expirationDate = DATETIME_FORMAT.parse(expirationDate);
        }
    }

    @XmlTransient
    public Date getExpirationDate() {
        return this._expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this._expirationDate = expirationDate;
    }

    @XmlElement(name="PROVIDER")
    public Provider getPackageProvider() {
        return this._packageProvider;
    }

    public void setPackageProvider(Provider provider) {
        this._packageProvider = provider;
    }

    @XmlElement(name="SERVER", required=true)
    public Server getServer() {
        return this._server;
    }

    public void setServer(Server server) {
        if (server == null) {
            throw new NullPointerException("no server");
        }
        this._server = server;
    }

    @XmlElement(name="TRACKLIST", required=true)
    public Tracklist getTracklist() {
        return this._trackList;
    }

    public void setTracklist(Tracklist trackList) {
        trackList.setParent(this);
        this._trackList = trackList;
    }

    @XmlElement(name="SIG")
    public String getSignature() {
        return this._signature;
    }

    public void setSignature(String signature) {
        this._signature = StringUtils.normalize(signature);
    }
}

