/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.rmp;

import christophedelory.content.type.ContentType;
import christophedelory.io.IOUtils;
import christophedelory.player.PlayerSupport;
import christophedelory.playlist.AbstractPlaylistComponent;
import christophedelory.playlist.Media;
import christophedelory.playlist.Parallel;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.rmp.Package;
import christophedelory.playlist.rmp.Provider;
import christophedelory.playlist.rmp.Track;
import christophedelory.playlist.rmp.Tracklist;
import christophedelory.xml.Version;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;

public class RmpProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".rmp"}, new String[]{"application/vnd.rn-rn_music_package"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.REALPLAYER, true, null)}, "Real Metadata Package (RMP)")};

    @Override
    public String getId() {
        return "rmp";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        String str = IOUtils.toString(in, enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        StringReader reader = new StringReader(str);
        JAXBContext jc = JAXBContext.newInstance((String)"christophedelory.playlist.rmp");
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        SpecificPlaylist ret = (SpecificPlaylist)unmarshaller.unmarshal((Reader)reader);
        ret.setProvider(this);
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        Package ret = new Package();
        ret.setProvider(this);
        ret.setTitle("Lizzy v" + Version.CURRENT + " RMP playlist");
        ret.setAction("import,replace");
        ret.setTarget(Integer.toString(System.identityHashCode(ret)));
        ret.getTracklist().setId(Integer.toString(System.identityHashCode(ret.getTracklist())));
        Provider provider = new Provider();
        provider.setAuthor("Christophe Delory");
        provider.setName("Lizzy v" + Version.CURRENT);
        provider.setUrlString("http://sourceforge.net/projects/lizzy/");
        provider.setCopyright("Copyright (c) 2008-2009, Christophe Delory");
        provider.setContact("cdelory@users.sourceforge.net");
        ret.setPackageProvider(provider);
        this.addToPlaylist(ret.getTracklist(), playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(Tracklist trackList, AbstractPlaylistComponent component) throws Exception {
        block11: {
            block10: {
                if (!(component instanceof Sequence)) break block10;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A RMP playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = sequence.getComponents();
                for (int iter = 0; iter < sequence.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(trackList, c);
                    }
                }
                break block11;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A RMP playlist cannot play different media at the same time");
            }
            if (!(component instanceof Media)) break block11;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A RMP playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A RMP playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    Track track = new Track();
                    track.setId(Integer.toString(System.identityHashCode(track)));
                    track.setTitle(media.getSource().toString());
                    track.setFileName(media.getSource().toString());
                    if (media.getSource().getLength() >= 0L) {
                        track.setSize(media.getSource().getLength());
                    }
                    if (media.getSource().getDuration() >= 0L) {
                        track.setDuration((int)(media.getSource().getDuration() / 1000L));
                    }
                    trackList.addTrack(track);
                }
            }
        }
    }
}

