/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.rss;

import christophedelory.content.Content;
import christophedelory.playlist.Media;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.rss.Enclosure;
import christophedelory.rss.Item;
import christophedelory.rss.RSS;
import christophedelory.rss.media.Group;
import christophedelory.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;

public class RSSPlaylist
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private RSS _rss = new RSS();

    @Override
    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/rss");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.getMarshaller().setNamespaceMapping("media", "http://search.yahoo.com/mrss/");
        serializer.marshal((Object)this._rss, writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (Item item : this._rss.getChannel().getItems()) {
            Enclosure enclosure = item.getEnclosure();
            if (enclosure == null || enclosure.getURL() == null) {
                block1: for (Group mediaGroup : item.getMediaGroups()) {
                    boolean foundOne = false;
                    for (christophedelory.rss.media.Content mediaContent : mediaGroup.getMediaContents()) {
                        if (!mediaContent.isDefault() || !this.addMediaContent(mediaContent, ret.getRootSequence())) continue;
                        foundOne = true;
                        break;
                    }
                    if (foundOne) continue;
                    for (christophedelory.rss.media.Content mediaContent : mediaGroup.getMediaContents()) {
                        if (!this.addMediaContent(mediaContent, ret.getRootSequence())) continue;
                        foundOne = true;
                        continue block1;
                    }
                }
                for (christophedelory.rss.media.Content mediaContent : item.getMediaContents()) {
                    this.addMediaContent(mediaContent, ret.getRootSequence());
                }
                continue;
            }
            Media media = new Media();
            Content content = new Content(enclosure.getURL());
            content.setLength(enclosure.getLength());
            content.setType(enclosure.getType());
            media.setSource(content);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }

    private boolean addMediaContent(christophedelory.rss.media.Content mediaContent, Sequence sequence) {
        boolean ret = false;
        if (mediaContent.getURL() != null) {
            Media media = new Media();
            Content content = new Content(mediaContent.getURL());
            content.setType(mediaContent.getType());
            if (mediaContent.getFileSize() != null) {
                content.setLength(mediaContent.getFileSize());
            }
            if (mediaContent.getDuration() != null) {
                content.setDuration(mediaContent.getDuration().longValue() * 1000L);
            }
            if (mediaContent.getWidth() != null) {
                content.setWidth(mediaContent.getWidth());
            }
            if (mediaContent.getHeight() != null) {
                content.setHeight(mediaContent.getHeight());
            }
            media.setSource(content);
            sequence.addComponent(media);
            ret = true;
        } else if (mediaContent.getMediaPlayer() != null && mediaContent.getMediaPlayer().getURL() != null) {
            Media media = new Media();
            Content content = new Content(mediaContent.getMediaPlayer().getURL());
            content.setType(mediaContent.getType());
            if (mediaContent.getFileSize() != null) {
                content.setLength(mediaContent.getFileSize());
            }
            if (mediaContent.getDuration() != null) {
                content.setDuration(mediaContent.getDuration().longValue() * 1000L);
            }
            media.setSource(content);
            sequence.addComponent(media);
            ret = true;
        }
        return ret;
    }

    public RSS getRSS() {
        return this._rss;
    }

    public void setRSS(RSS rss) {
        if (rss == null) {
            throw new NullPointerException("No RSS document");
        }
        this._rss = rss;
    }
}

