/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.rss;

import christophedelory.content.type.ContentType;
import christophedelory.io.IOUtils;
import christophedelory.player.PlayerSupport;
import christophedelory.playlist.AbstractPlaylistComponent;
import christophedelory.playlist.Media;
import christophedelory.playlist.Parallel;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.rss.RSSPlaylist;
import christophedelory.rss.Channel;
import christophedelory.rss.Enclosure;
import christophedelory.rss.Item;
import christophedelory.rss.RSS;
import christophedelory.rss.media.Content;
import christophedelory.xml.Version;
import christophedelory.xml.XmlSerializer;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.util.Date;
import org.apache.commons.logging.Log;

public class RSSProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".rss", ".xml"}, new String[]{"application/rss+xml"}, new PlayerSupport[0], "RSS Document")};
    private boolean _useRSSMedia = false;

    @Override
    public String getId() {
        return "rss";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        String str = IOUtils.toString(in, enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/rss");
        serializer.getUnmarshaller().setIgnoreExtraElements(true);
        StringReader reader = new StringReader(str);
        RSS rss = (RSS)serializer.unmarshal(reader);
        RSSPlaylist ret = new RSSPlaylist();
        ret.setProvider(this);
        ret.setRSS(rss);
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        RSSPlaylist ret = new RSSPlaylist();
        ret.setProvider(this);
        Channel channel = ret.getRSS().getChannel();
        channel.setTitle("Lizzy v" + Version.CURRENT + " RSS playlist");
        channel.setDescription("A list of media contents");
        channel.setLinkString("http://sourceforge.net/projects/lizzy/");
        channel.setLanguage("en");
        channel.setCopyright("Copyright (c) 2008-2009, Christophe Delory");
        channel.setPubDate(new Date());
        channel.setLastBuildDate(new Date());
        channel.setGenerator("Lizzy v" + Version.CURRENT);
        this.addToPlaylist(channel, playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(Channel channel, AbstractPlaylistComponent component) throws Exception {
        block17: {
            block16: {
                if (!(component instanceof Sequence)) break block16;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A RSS playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = sequence.getComponents();
                for (int iter = 0; iter < sequence.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(channel, c);
                    }
                }
                break block17;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A RSS playlist doesn't support concurrent media");
            }
            if (!(component instanceof Media)) break block17;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A RSS playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A RSS playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    URI url;
                    Item item = new Item();
                    if (this._useRSSMedia) {
                        Content content = new Content();
                        content.setURL(media.getSource().getURI());
                        url = content.getURL();
                        content.setFileSize(media.getSource().getLength());
                        content.setType(media.getSource().getType());
                        content.setDefault(true);
                        if (media.getSource().getDuration() >= 0L) {
                            content.setDuration((int)((media.getSource().getDuration() + 999L) / 1000L));
                        }
                        if (media.getSource().getWidth() >= 0) {
                            content.setWidth(media.getSource().getWidth());
                        }
                        if (media.getSource().getHeight() >= 0) {
                            content.setHeight(media.getSource().getHeight());
                        }
                        item.addMediaContent(content);
                    } else {
                        Enclosure enclosure = new Enclosure();
                        enclosure.setURL(media.getSource().getURI());
                        url = enclosure.getURL();
                        enclosure.setLength(media.getSource().getLength());
                        if (media.getSource().getType() != null) {
                            enclosure.setType(media.getSource().getType());
                        }
                        item.setEnclosure(enclosure);
                    }
                    if (url.getPath() == null) {
                        item.setTitle(media.getSource().toString());
                    } else {
                        File path = new File(url.getPath());
                        item.setTitle(path.getName());
                    }
                    channel.addItem(item);
                }
            }
        }
    }

    public void setUseRSSMedia(boolean useRSSMedia) {
        this._useRSSMedia = useRSSMedia;
    }
}

