/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.smil;

import christophedelory.lang.StringUtils;
import christophedelory.playlist.smil.Core;
import christophedelory.playlist.smil.Region;
import christophedelory.playlist.smil.RegistrationPoint;
import christophedelory.playlist.smil.RootLayout;
import christophedelory.playlist.smil.SmilVisitor;
import christophedelory.playlist.smil.TopLayout;
import java.util.ArrayList;
import java.util.List;

public class Layout
extends Core {
    private final List<TopLayout> _topLayouts = new ArrayList<TopLayout>();
    private RootLayout _rootLayout = null;
    private final List<Region> _regions = new ArrayList<Region>();
    private final List<RegistrationPoint> _regPoints = new ArrayList<RegistrationPoint>();
    private String _type = null;

    public List<TopLayout> getTopLayouts() {
        return this._topLayouts;
    }

    public void addTopLayout(TopLayout topLayout) {
        if (topLayout == null) {
            throw new NullPointerException("no top layout");
        }
        this._topLayouts.add(topLayout);
    }

    public RootLayout getRootLayout() {
        return this._rootLayout;
    }

    public void setRootLayout(RootLayout rootLayout) {
        this._rootLayout = rootLayout;
    }

    public List<Region> getRegions() {
        return this._regions;
    }

    public void addRegion(Region region) {
        if (region == null) {
            throw new NullPointerException("no region");
        }
        this._regions.add(region);
    }

    public Region findRegionById(String regionId) {
        Region ret = null;
        for (Region region : this._regions) {
            if (!regionId.equals(region.getId())) continue;
            ret = region;
            break;
        }
        return ret;
    }

    public List<RegistrationPoint> getRegistrationPoints() {
        return this._regPoints;
    }

    public void addRegistrationPoint(RegistrationPoint regPoint) {
        if (regPoint == null) {
            throw new NullPointerException("no registration point");
        }
        this._regPoints.add(regPoint);
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = StringUtils.normalize(type);
    }

    public void acceptDown(SmilVisitor visitor) {
        visitor.beginVisitLayout(this);
        if (this._rootLayout != null) {
            this._rootLayout.acceptDown(visitor);
        }
        Region[] regions = new Region[this._regions.size()];
        this._regions.toArray(regions);
        for (Region region : regions) {
            region.acceptDown(visitor);
        }
        visitor.endVisitLayout(this);
    }
}

