/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.smil;

import christophedelory.lang.StringUtils;
import christophedelory.playlist.smil.Position;
import christophedelory.playlist.smil.SmilVisitor;
import java.util.ArrayList;
import java.util.List;

public class Region
extends Position {
    private final List<Region> _regions = new ArrayList<Region>();
    private String _regionName = null;
    private String _backgroundColor = null;
    private String _backgroundImage = null;
    private String _height = null;
    private String _width = null;
    private Boolean _skipContent = null;
    private String _soundLevel = "100%";
    private Integer _zIndex = null;
    private String _soundAlign = null;

    public List<Region> getRegions() {
        return this._regions;
    }

    public void addRegion(Region region) {
        if (region == null) {
            throw new NullPointerException("no region");
        }
        this._regions.add(region);
    }

    public String getRegionName() {
        return this._regionName;
    }

    public void setRegionName(String regionName) {
        this._regionName = StringUtils.normalize(regionName);
    }

    public String getBackgroundColor() {
        return this._backgroundColor;
    }

    public void setBackgroundColor(String color) {
        this._backgroundColor = StringUtils.normalize(color);
    }

    public String getBackgroundImage() {
        return this._backgroundImage;
    }

    public void setBackgroundImage(String image) {
        this._backgroundImage = StringUtils.normalize(image);
    }

    public String getHeightString() {
        return this._height;
    }

    public void setHeightString(String height) {
        this._height = StringUtils.normalize(height);
    }

    public void setHeight(int height) {
        this._height = Integer.toString(height);
    }

    public String getWidthString() {
        return this._width;
    }

    public void setWidthString(String width) {
        this._width = StringUtils.normalize(width);
    }

    public void setWidth(int width) {
        this._width = Integer.toString(width);
    }

    public boolean isSkipContent() {
        return this._skipContent == null ? false : this._skipContent;
    }

    public Boolean getSkipContent() {
        return this._skipContent;
    }

    public void setSkipContent(Boolean skipContent) {
        this._skipContent = skipContent;
    }

    public String getSoundLevelString() {
        return this._soundLevel;
    }

    public void setSoundLevelString(String soundLevel) {
        this._soundLevel = StringUtils.normalize(soundLevel);
    }

    public Integer getZIndex() {
        return this._zIndex;
    }

    public void setZIndex(Integer zIndex) {
        this._zIndex = zIndex;
    }

    public void setZIndex(int zIndex) {
        this._zIndex = zIndex;
    }

    public String getSoundAlign() {
        return this._soundAlign;
    }

    public void setSoundAlign(String soundAlign) {
        this._soundAlign = StringUtils.normalize(soundAlign);
    }

    public void acceptDown(SmilVisitor visitor) {
        visitor.beginVisitRegion(this);
        Region[] regions = new Region[this._regions.size()];
        this._regions.toArray(regions);
        for (Region region : regions) {
            region.acceptDown(visitor);
        }
        visitor.endVisitRegion(this);
    }

    public int hashCode() {
        return this.getId() == null ? 0 : this.getId().hashCode();
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o != null) {
            if (o instanceof Region) {
                Region region = (Region)o;
                ret = this.getId() == null ? this.getId() == null : this.getId().equals(region.getId());
            } else if (o instanceof String) {
                String s = (String)o;
                ret = this.getId() == null ? s == null : this.getId().equals(s);
            }
        }
        return ret;
    }
}

