/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.smil;

import christophedelory.content.Content;
import christophedelory.playlist.AbstractTimeContainer;
import christophedelory.playlist.Media;
import christophedelory.playlist.Parallel;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.smil.AbstractSmilElement;
import christophedelory.playlist.smil.BaseSmilVisitor;
import christophedelory.playlist.smil.Body;
import christophedelory.playlist.smil.Core;
import christophedelory.playlist.smil.Head;
import christophedelory.playlist.smil.ParallelTimingElement;
import christophedelory.playlist.smil.Reference;
import christophedelory.playlist.smil.SequentialTimingElement;
import christophedelory.playlist.smil.SmilVisitor;
import christophedelory.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class Smil
extends Core
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private Head _header = null;
    private Body _body = null;

    @Override
    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/playlist/smil");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this, writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        if (this._body != null) {
            Float repeatCount = this._body.getRepeatCount();
            if (repeatCount != null) {
                ret.getRootSequence().setRepeatCount(repeatCount.intValue());
            }
            for (AbstractSmilElement smilElem : this._body.getSmilElements()) {
                this.addToContainer(smilElem, ret.getRootSequence());
            }
            ret.normalize();
        }
        return ret;
    }

    private void addToContainer(AbstractSmilElement smilElement, AbstractTimeContainer currentContainer) {
        Reference smilRef;
        if (smilElement instanceof SequentialTimingElement) {
            SequentialTimingElement smilSeq = (SequentialTimingElement)smilElement;
            Sequence seq = new Sequence();
            Float repeatCount = smilSeq.getRepeatCount();
            if (repeatCount != null) {
                seq.setRepeatCount(repeatCount.intValue());
            }
            currentContainer.addComponent(seq);
            for (AbstractSmilElement smilElem : smilSeq.getSmilElements()) {
                this.addToContainer(smilElem, seq);
            }
        } else if (smilElement instanceof ParallelTimingElement) {
            ParallelTimingElement smilPar = (ParallelTimingElement)smilElement;
            Parallel par = new Parallel();
            Float repeatCount = smilPar.getRepeatCount();
            if (repeatCount != null) {
                par.setRepeatCount(repeatCount.intValue());
            }
            currentContainer.addComponent(par);
            for (AbstractSmilElement smilElem : smilPar.getSmilElements()) {
                this.addToContainer(smilElem, par);
            }
        } else if (smilElement instanceof Reference && (smilRef = (Reference)smilElement).getSource() != null) {
            Float repeatCount;
            Media media = new Media();
            Content content = new Content(smilRef.getSource());
            content.setType(smilRef.getType());
            media.setSource(content);
            if (smilRef.getDuration() != null && smilRef.getDuration() > 0L) {
                media.setDuration(smilRef.getDuration());
            }
            if ((repeatCount = smilRef.getRepeatCount()) != null) {
                media.setRepeatCount(repeatCount.intValue());
            }
            currentContainer.addComponent(media);
        }
    }

    public Head getHeader() {
        return this._header;
    }

    public void setHeader(Head header) {
        this._header = header;
    }

    public Body getBody() {
        return this._body;
    }

    public void setBody(Body body) {
        this._body = body;
    }

    public void acceptDown(SmilVisitor visitor) {
        visitor.beginVisitSmil(this);
        if (this._header != null) {
            this._header.acceptDown(visitor);
        }
        if (this._body != null) {
            this._body.acceptDown(visitor);
        }
        visitor.endVisitSmil(this);
    }

    public List<Reference> findReferencesFromRegionId(String regionId) {
        ReferenceVisitor v = new ReferenceVisitor(regionId);
        this.acceptDown(v);
        return v.getReferences();
    }

    private static class ReferenceVisitor
    extends BaseSmilVisitor {
        private final List<Reference> _result = new ArrayList<Reference>();
        private final String _regionId;

        public ReferenceVisitor(String regionId) {
            this._regionId = regionId;
        }

        @Override
        public void beginVisitReference(Reference target) {
            if (this._regionId.equals(target.getRegionString())) {
                this._result.add(target);
            }
        }

        public List<Reference> getReferences() {
            return this._result;
        }
    }
}

