/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.smil;

import christophedelory.content.type.ContentType;
import christophedelory.io.IOUtils;
import christophedelory.player.PlayerSupport;
import christophedelory.playlist.AbstractPlaylistComponent;
import christophedelory.playlist.Media;
import christophedelory.playlist.Parallel;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.smil.AbstractTimingElement;
import christophedelory.playlist.smil.Body;
import christophedelory.playlist.smil.ParallelTimingElement;
import christophedelory.playlist.smil.Reference;
import christophedelory.playlist.smil.SequentialTimingElement;
import christophedelory.playlist.smil.Smil;
import christophedelory.xml.XmlSerializer;
import java.io.InputStream;
import java.io.StringReader;
import org.apache.commons.logging.Log;

public class SmilProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".smil", ".smi"}, new String[]{"application/smil+xml", "application/smil"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, false, null), new PlayerSupport(PlayerSupport.Player.QUICKTIME, true, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Synchronized Multimedia Integration Language (SMIL)")};

    @Override
    public String getId() {
        return "smil";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        String str = IOUtils.toString(in, enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/playlist/smil");
        serializer.getUnmarshaller().setIgnoreExtraElements(true);
        StringReader reader = new StringReader(str);
        SpecificPlaylist ret = (SpecificPlaylist)serializer.unmarshal(reader);
        ret.setProvider(this);
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        AbstractPlaylistComponent[] components;
        Smil ret = new Smil();
        ret.setProvider(this);
        Body body = new Body();
        body.setRepeatCount(Float.valueOf(playlist.getRootSequence().getRepeatCount()));
        ret.setBody(body);
        for (AbstractPlaylistComponent component : components = playlist.getRootSequence().getComponents()) {
            this.addToPlaylist(body, component);
        }
        return ret;
    }

    private void addToPlaylist(AbstractTimingElement timingElement, AbstractPlaylistComponent component) {
        if (component instanceof Sequence) {
            AbstractPlaylistComponent[] components;
            Sequence sequence = (Sequence)component;
            SequentialTimingElement seq = new SequentialTimingElement();
            seq.setRepeatCount(Float.valueOf(sequence.getRepeatCount()));
            timingElement.addSmilElement(seq);
            for (AbstractPlaylistComponent c : components = sequence.getComponents()) {
                this.addToPlaylist(seq, c);
            }
        } else if (component instanceof Parallel) {
            AbstractPlaylistComponent[] components;
            Parallel parallel = (Parallel)component;
            ParallelTimingElement par = new ParallelTimingElement();
            par.setRepeatCount(Float.valueOf(parallel.getRepeatCount()));
            timingElement.addSmilElement(par);
            for (AbstractPlaylistComponent c : components = parallel.getComponents()) {
                this.addToPlaylist(par, c);
            }
        } else if (component instanceof Media) {
            Media media = (Media)component;
            Reference ref = new Reference();
            if (media.getSource() != null) {
                ref.setSource(media.getSource().toString());
                ref.setType(media.getSource().getType());
            }
            ref.setDuration(media.getDuration());
            ref.setRepeatCount(Float.valueOf(media.getRepeatCount()));
            timingElement.addSmilElement(ref);
        }
    }
}

