/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.wpl;

import christophedelory.content.type.ContentType;
import christophedelory.io.IOUtils;
import christophedelory.player.PlayerSupport;
import christophedelory.playlist.AbstractPlaylistComponent;
import christophedelory.playlist.Parallel;
import christophedelory.playlist.Playlist;
import christophedelory.playlist.Sequence;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.wpl.Body;
import christophedelory.playlist.wpl.Head;
import christophedelory.playlist.wpl.Media;
import christophedelory.playlist.wpl.Meta;
import christophedelory.playlist.wpl.Seq;
import christophedelory.playlist.wpl.Smil;
import christophedelory.xml.XmlSerializer;
import java.io.InputStream;
import java.io.StringReader;
import org.apache.commons.logging.Log;

public class WplProvider
implements SpecificPlaylistProvider {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".wpl"}, new String[]{"application/vnd.ms-wpl"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINAMP, false, null), new PlayerSupport(PlayerSupport.Player.WINDOWS_MEDIA_PLAYER, true, null)}, "Windows Media Player Playlist (WPL)")};

    @Override
    public String getId() {
        return "wpl";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream in, String encoding, Log logger) throws Exception {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        String str = IOUtils.toString(in, enc);
        str = str.replace("&", "&amp;");
        str = str.replaceAll("&amp;([a-zA-Z0-9#]+;)", "&$1");
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/playlist/wpl");
        serializer.getUnmarshaller().setIgnoreExtraElements(false);
        StringReader reader = new StringReader(str);
        SpecificPlaylist ret = (SpecificPlaylist)serializer.unmarshal(reader);
        ret.setProvider(this);
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws Exception {
        Smil ret = new Smil();
        ret.setProvider(this);
        Body body = new Body();
        ret.setBody(body);
        this.addToPlaylist(body.getSeq(), playlist.getRootSequence());
        Head header = new Head();
        ret.setHeader(header);
        Meta meta = new Meta();
        meta.setName("ItemCount");
        meta.setContent(Integer.toString(body.getSeq().getMedias().size()));
        header.addMeta(meta);
        return ret;
    }

    private void addToPlaylist(Seq wplSeq, AbstractPlaylistComponent component) throws Exception {
        block9: {
            block8: {
                if (!(component instanceof Sequence)) break block8;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0) {
                    throw new IllegalArgumentException("A WPL playlist cannot handle a sequence repeated indefinitely");
                }
                AbstractPlaylistComponent[] components = sequence.getComponents();
                for (int iter = 0; iter < sequence.getRepeatCount(); ++iter) {
                    for (AbstractPlaylistComponent c : components) {
                        this.addToPlaylist(wplSeq, c);
                    }
                }
                break block9;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A WPL playlist cannot play media at the same time");
            }
            if (!(component instanceof christophedelory.playlist.Media)) break block9;
            christophedelory.playlist.Media media = (christophedelory.playlist.Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A WPL playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0) {
                throw new IllegalArgumentException("A WPL playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                for (int iter = 0; iter < media.getRepeatCount(); ++iter) {
                    Media wplMedia = new Media();
                    wplMedia.setSource(media.getSource().toString());
                    wplSeq.addMedia(wplMedia);
                }
            }
        }
    }
}

