/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.playlist.xspf;

import christophedelory.content.Content;
import christophedelory.lang.StringUtils;
import christophedelory.playlist.Media;
import christophedelory.playlist.SpecificPlaylist;
import christophedelory.playlist.SpecificPlaylistProvider;
import christophedelory.playlist.xspf.Attribution;
import christophedelory.playlist.xspf.Link;
import christophedelory.playlist.xspf.Location;
import christophedelory.playlist.xspf.Meta;
import christophedelory.playlist.xspf.StringContainer;
import christophedelory.playlist.xspf.Track;
import christophedelory.xml.XmlSerializer;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exolab.castor.types.AnyNode;

public class Playlist
implements SpecificPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private Integer _version = 1;
    private String _title = null;
    private String _creator = null;
    private String _annotation = null;
    private String _info = null;
    private String _location = null;
    private String _identifier = null;
    private String _image = null;
    private Date _date = null;
    private String _license = null;
    private Attribution _attribution = null;
    private final List<Link> _links = new ArrayList<Link>();
    private final List<Meta> _metas = new ArrayList<Meta>();
    private final List<Track> _tracks = new ArrayList<Track>();
    private final List<AnyNode> _extensions = new ArrayList<AnyNode>();

    @Override
    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws Exception {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XmlSerializer.getMapping("christophedelory/playlist/xspf");
        serializer.getMarshaller().setProperty("org.exolab.castor.indent", "true");
        serializer.marshal((Object)this, writer, false);
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] bytes = writer.toString().getBytes(enc);
        out.write(bytes);
        out.flush();
    }

    @Override
    public christophedelory.playlist.Playlist toPlaylist() {
        christophedelory.playlist.Playlist ret = new christophedelory.playlist.Playlist();
        for (Track track : this._tracks) {
            for (StringContainer stringContainer : track.getStringContainers()) {
                if (!(stringContainer instanceof Location) || stringContainer.getText() == null) continue;
                Media media = new Media();
                Content content = new Content(stringContainer.getText());
                media.setSource(content);
                if (track.getDuration() != null) {
                    content.setDuration(track.getDuration().longValue());
                }
                ret.getRootSequence().addComponent(media);
            }
        }
        ret.normalize();
        return ret;
    }

    public Integer getVersion() {
        return this._version;
    }

    public void setVersion(Integer version) {
        if (version == null) {
            throw new NullPointerException("no version number");
        }
        this._version = version;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = StringUtils.normalize(title);
    }

    public String getCreator() {
        return this._creator;
    }

    public void setCreator(String creator) {
        this._creator = StringUtils.normalize(creator);
    }

    public String getAnnotation() {
        return this._annotation;
    }

    public void setAnnotation(String annotation) {
        this._annotation = StringUtils.normalize(annotation);
    }

    public String getInfo() {
        return this._info;
    }

    public void setInfo(String info) {
        this._info = StringUtils.normalize(info);
    }

    public String getLocation() {
        return this._location;
    }

    public void setLocation(String location) {
        this._location = StringUtils.normalize(location);
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public void setIdentifier(String identifier) {
        this._identifier = StringUtils.normalize(identifier);
    }

    public String getImage() {
        return this._image;
    }

    public void setImage(String image) {
        this._image = StringUtils.normalize(image);
    }

    public Date getDate() {
        return this._date;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public String getLicense() {
        return this._license;
    }

    public void setLicense(String license) {
        this._license = StringUtils.normalize(license);
    }

    public Attribution getAttribution() {
        return this._attribution;
    }

    public void setAttribution(Attribution attribution) {
        this._attribution = attribution;
    }

    public List<AnyNode> getExtensions() {
        return this._extensions;
    }

    public void addExtension(Object extension) {
        if (!(extension instanceof AnyNode)) {
            throw new IllegalArgumentException(AnyNode.class + " expected");
        }
        AnyNode anyNode = (AnyNode)extension;
        AnyNode attr = anyNode.getFirstAttribute();
        if (attr == null) {
            throw new IllegalArgumentException("No application attribute");
        }
        if (!"application".equals(attr.getLocalName())) {
            throw new IllegalArgumentException("Unknown attribute");
        }
        this._extensions.add(anyNode);
    }

    public void addLink(Link link) {
        if (link == null) {
            throw new NullPointerException("no link");
        }
        this._links.add(link);
    }

    public List<Link> getLinks() {
        return this._links;
    }

    public void addMeta(Meta meta) {
        if (meta == null) {
            throw new NullPointerException("no meta");
        }
        this._metas.add(meta);
    }

    public List<Meta> getMetas() {
        return this._metas;
    }

    public void addTrack(Track track) {
        if (track == null) {
            throw new NullPointerException("no track");
        }
        this._tracks.add(track);
    }

    public List<Track> getTracks() {
        return this._tracks;
    }
}

