/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.rss;

import christophedelory.rss.Category;
import christophedelory.rss.Cloud;
import christophedelory.rss.Image;
import christophedelory.rss.Item;
import christophedelory.rss.RFC822;
import christophedelory.rss.RSS;
import christophedelory.rss.TextInput;
import christophedelory.rss.media.BaseMedia;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Channel
extends BaseMedia {
    private String _title = null;
    private URI _link = null;
    private String _description = null;
    private String _language = null;
    private String _copyright = null;
    private String _managingEditor = null;
    private String _webMaster = null;
    private Date _pubDate = null;
    private Date _lastBuildDate = null;
    private final List<Category> _categories = new ArrayList<Category>();
    private String _generator = null;
    private String _docs = "http://blogs.law.harvard.edu/tech/rss";
    private Cloud _cloud = null;
    private Integer _ttl = null;
    private Image _image = null;
    private String _rating = null;
    private TextInput _textInput = null;
    private final List<Integer> _skipHours = new ArrayList<Integer>();
    private final List<String> _skipDays = new ArrayList<String>();
    private final List<Item> _items = new ArrayList<Item>();
    private transient RSS _rss = null;

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title.trim();
    }

    public void setLinkString(String link) throws URISyntaxException {
        this._link = new URI(link);
    }

    public String getLinkString() {
        return this._link.toString();
    }

    public void setLink(URI link) {
        if (link == null) {
            throw new NullPointerException("No link");
        }
        this._link = link;
    }

    public URI getLink() {
        return this._link;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description.trim();
    }

    public String getLanguage() {
        return this._language;
    }

    public void setLanguage(String language) {
        this._language = language;
    }

    public String getCopyright() {
        return this._copyright;
    }

    public void setCopyright(String copyright) {
        this._copyright = copyright;
    }

    public String getManagingEditor() {
        return this._managingEditor;
    }

    public void setManagingEditor(String managingEditor) {
        this._managingEditor = managingEditor;
    }

    public String getWebMaster() {
        return this._webMaster;
    }

    public void setWebMaster(String webMaster) {
        this._webMaster = webMaster;
    }

    public void setPubDateString(String pubDate) {
        this._pubDate = RFC822.valueOf(pubDate);
    }

    public String getPubDateString() {
        String ret = null;
        if (this._pubDate != null) {
            ret = RFC822.toString(this._pubDate);
        }
        return ret;
    }

    public void setPubDate(Date pubDate) {
        this._pubDate = pubDate;
    }

    public Date getPubDate() {
        return this._pubDate;
    }

    public void setLastBuildDateString(String lastBuildDate) {
        this._lastBuildDate = RFC822.valueOf(lastBuildDate);
    }

    public String getLastBuildDateString() {
        String ret = null;
        if (this._lastBuildDate != null) {
            ret = RFC822.toString(this._lastBuildDate);
        }
        return ret;
    }

    public void setLastBuildDate(Date lastBuildDate) {
        this._lastBuildDate = lastBuildDate;
    }

    public Date getLastBuildDate() {
        return this._lastBuildDate;
    }

    public List<Category> getCategories() {
        return this._categories;
    }

    public void addCategory(Category category) {
        if (category == null) {
            throw new NullPointerException("no category");
        }
        this._categories.add(category);
    }

    public void setGenerator(String generator) {
        this._generator = generator;
    }

    public String getGenerator() {
        return this._generator;
    }

    public void setDocs(String docs) {
        this._docs = docs;
    }

    public String getDocs() {
        return this._docs;
    }

    public void setCloud(Cloud cloud) {
        this._cloud = cloud;
    }

    public Cloud getCloud() {
        return this._cloud;
    }

    public void setTTL(Integer ttl) {
        this._ttl = ttl;
    }

    public Integer getTTL() {
        return this._ttl;
    }

    public void setImage(Image image) {
        this._image = image;
    }

    public Image getImage() {
        return this._image;
    }

    public void setRating(String rating) {
        this._rating = rating;
    }

    public String getRating() {
        return this._rating;
    }

    public void setTextInput(TextInput textInput) {
        this._textInput = textInput;
    }

    public TextInput getTextInput() {
        return this._textInput;
    }

    public List<Integer> getSkipHours() {
        return this._skipHours;
    }

    public void addSkipHour(Integer skipHour) {
        if (skipHour == null) {
            throw new NullPointerException("no skipHour");
        }
        this._skipHours.add(skipHour);
    }

    public List<String> getSkipDays() {
        return this._skipDays;
    }

    public void addSkipDay(String skipDay) {
        if (skipDay == null) {
            throw new NullPointerException("no skipDay");
        }
        this._skipDays.add(skipDay);
    }

    public List<Item> getItems() {
        return this._items;
    }

    public void addItem(Item item) {
        item.setChannel(this);
        this._items.add(item);
    }

    void setRSS(RSS rss) {
        this._rss = rss;
    }

    public RSS getRSS() {
        return this._rss;
    }
}

