/*
 * Decompiled with CFR 0.152.
 */
package christophedelory.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.xml.sax.InputSource;

public final class XmlSerializer {
    private static Hashtable<String, XmlSerializer> _mappings = new Hashtable();
    private Marshaller _marshaller = null;
    private Unmarshaller _unmarshaller = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlSerializer getMapping(String packageName) throws IOException, MappingException {
        StringBuilder sb = new StringBuilder();
        if (packageName != null && packageName.length() > 0) {
            sb.append(packageName);
            sb.append('/');
        }
        sb.append("mapping.xml");
        String mappingFileName = sb.toString();
        Hashtable<String, XmlSerializer> hashtable = _mappings;
        synchronized (hashtable) {
            XmlSerializer mappingDescriptor = _mappings.get(mappingFileName);
            if (mappingDescriptor == null) {
                mappingDescriptor = new XmlSerializer();
                URL mappingURL = XmlSerializer.class.getClassLoader().getResource(mappingFileName);
                if (mappingURL == null) {
                    throw new FileNotFoundException(mappingFileName);
                }
                Mapping mapping = new Mapping(XmlSerializer.class.getClassLoader());
                mapping.loadMapping(mappingURL);
                mappingDescriptor.setMapping(mapping);
                _mappings.put(mappingFileName, mappingDescriptor);
            }
            return mappingDescriptor;
        }
    }

    public Object unmarshal(String fileName) throws Exception {
        return this.unmarshal(new FileInputStream(fileName));
    }

    public Object unmarshal(File file) throws Exception {
        return this.unmarshal(new FileInputStream(file));
    }

    public Object unmarshal(URL url) throws Exception {
        return this.unmarshal(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(InputStream in) throws Exception {
        InputSource is = new InputSource(in);
        Unmarshaller unmarshaller = this._unmarshaller;
        synchronized (unmarshaller) {
            return this._unmarshaller.unmarshal(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Reader reader) throws Exception {
        Unmarshaller unmarshaller = this._unmarshaller;
        synchronized (unmarshaller) {
            return this._unmarshaller.unmarshal(reader);
        }
    }

    public void marshal(Object o, String fileName, boolean asDocument) throws Exception {
        FileWriter out = new FileWriter(fileName, false);
        this.marshal(o, out, asDocument);
        out.flush();
        out.close();
    }

    public void marshal(Object o, File file, boolean asDocument) throws Exception {
        FileWriter out = new FileWriter(file, false);
        this.marshal(o, out, asDocument);
        out.flush();
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object o, Writer out, boolean asDocument) throws Exception {
        Marshaller marshaller = this._marshaller;
        synchronized (marshaller) {
            this._marshaller.setWriter(out);
            this._marshaller.setMarshalAsDocument(asDocument);
            this._marshaller.setEncoding("ISO-8859-1");
            this._marshaller.marshal(o);
        }
    }

    private XmlSerializer() {
    }

    public Marshaller getMarshaller() {
        return this._marshaller;
    }

    public Unmarshaller getUnmarshaller() {
        return this._unmarshaller;
    }

    private void setMapping(Mapping mapping) throws MappingException {
        this._unmarshaller = new Unmarshaller(mapping);
        this._unmarshaller.setValidation(false);
        this._unmarshaller.setIgnoreExtraElements(true);
        this._marshaller = new Marshaller();
        this._marshaller.setMapping(mapping);
        this._marshaller.setValidation(false);
    }
}

