/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.SpecificPlaylistFactory;
import io.github.borewit.lizzy.playlist.SpecificPlaylistProvider;
import java.util.List;

public final class ContentTypeInfo {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static String toString(ContentType contentType) {
        StringBuilder sb = new StringBuilder(contentType.getDescription());
        sb.append(LINE_SEPARATOR);
        sb.append("  Typical file name extension(s) [case-insensitive]: ");
        boolean first = true;
        for (String ext : contentType.getExtensions()) {
            if (!first) {
                sb.append(' ');
            }
            first = false;
            sb.append(ext);
        }
        sb.append(LINE_SEPARATOR);
        sb.append("  MIME type(s): ");
        first = true;
        for (String mimeType : contentType.getMimeTypes()) {
            if (!first) {
                sb.append(' ');
            }
            first = false;
            sb.append(mimeType);
        }
        sb.append(LINE_SEPARATOR);
        sb.append("  Supported player(s): ");
        first = true;
        for (PlayerSupport playerSupport : contentType.getPlayerSupports()) {
            if (!first) {
                sb.append(' ');
            }
            first = false;
            sb.append(PlayerSupport.toString(playerSupport.getPlayer()));
            sb.append(" [R");
            if (playerSupport.isSaved()) {
                sb.append('W');
            }
            sb.append(']');
        }
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    public static String toHTML(ContentType contentType) {
        StringBuilder sb = new StringBuilder("<tr valign=top><td>");
        sb.append(contentType.getDescription());
        sb.append("</td><td><code>");
        boolean first = true;
        for (String ext : contentType.getExtensions()) {
            if (!first) {
                sb.append(' ');
            }
            first = false;
            sb.append(ext);
        }
        sb.append("</code></td><td><code>");
        first = true;
        for (String mimeType : contentType.getMimeTypes()) {
            if (!first) {
                sb.append("<br>");
            }
            first = false;
            sb.append(mimeType);
        }
        sb.append("</code></td><td>");
        first = true;
        for (PlayerSupport playerSupport : contentType.getPlayerSupports()) {
            if (!first) {
                sb.append("<br>");
            }
            first = false;
            sb.append(PlayerSupport.toString(playerSupport.getPlayer()));
            sb.append(" [R");
            if (playerSupport.isSaved()) {
                sb.append('W');
            }
            sb.append(']');
        }
        sb.append("</td></tr>");
        return sb.toString();
    }

    public static void main(String[] args) {
        List<SpecificPlaylistProvider> providers = SpecificPlaylistFactory.getInstance().getProviders();
        boolean txt = args.length > 0;
        StringBuilder sb = new StringBuilder();
        if (txt) {
            sb.append("PLAYLIST FORMATS:");
            sb.append(LINE_SEPARATOR);
        } else {
            sb.append("<html><head><title>Playlist formats</title></head><body><table border=1 cellpadding=4 cellspacing=0><thead><tr valign=top><th>Playlist type</th><th>Typical file name extension(s) [case-insensitive]</th><th>MIME type(s)</th><th>Supported player(s)</th></tr></thead><tbody>");
        }
        for (SpecificPlaylistProvider provider : providers) {
            for (ContentType type : provider.getContentTypes()) {
                if (txt) {
                    sb.append(ContentTypeInfo.toString(type));
                    continue;
                }
                sb.append(ContentTypeInfo.toHTML(type));
            }
        }
        if (!txt) {
            sb.append("</tbody></table></body></html>");
        }
        System.out.println(sb);
    }

    private ContentTypeInfo() {
    }
}

