/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy;

import io.github.borewit.lizzy.content.ContentMetadataCenter;
import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.content.type.ContentTypeProvider;
import io.github.borewit.lizzy.playlist.BasePlaylistVisitor;
import io.github.borewit.lizzy.playlist.Media;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FetchContentMetadata
extends BasePlaylistVisitor {
    private final Logger logger = LogManager.getLogger(FetchContentMetadata.class);
    private boolean _connect = false;

    public void setConnect(boolean connect) {
        this._connect = connect;
    }

    @Override
    public void beginVisitMedia(Media target) {
        if (target.getSource() != null) {
            if (this._connect) {
                try {
                    target.getSource().connect();
                }
                catch (Exception e) {
                    this.logger.warn("Cannot access media content " + target.getSource(), (Throwable)e);
                }
                ContentMetadataCenter.getInstance().fillMetadata(target.getSource());
            }
            try {
                ContentType contentType = ContentTypeProvider.getInstance().getContentType(target.getSource().getURI());
                if (contentType != null) {
                    target.getSource().setType(contentType.getMimeTypes()[0]);
                }
            }
            catch (Exception e) {
                this.logger.warn("Cannot build URI for media content " + target.getSource(), (Throwable)e);
            }
        }
    }
}

