/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.content;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public class Content {
    private String _urlString;
    private transient URI _uri = null;
    private transient URL _url = null;
    private String _encoding = null;
    private long _length = -1L;
    private String _type = null;
    private long _lastModified = 0L;
    private long _duration = -1L;
    private int _width = -1;
    private int _height = -1;
    private transient Boolean _connected = null;

    public Content(String url) {
        this.setURL(url);
    }

    public Content(URI uri) {
        this.setURI(uri);
    }

    public Content(URL url) {
        this.setURL(url);
    }

    public void setURI(URI uri) {
        this._uri = uri.normalize();
        this._urlString = uri.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getURI() throws URISyntaxException {
        Content content = this;
        synchronized (content) {
            if (this._uri == null) {
                URI uri = null;
                if (this._url == null) {
                    try {
                        uri = new URI(this._urlString);
                    }
                    catch (URISyntaxException e) {
                        uri = null;
                    }
                    if (uri == null || !uri.isAbsolute()) {
                        uri = new File(this._urlString).toURI();
                    }
                } else {
                    uri = this._url.toURI();
                }
                this._uri = uri.normalize();
            }
        }
        return this._uri;
    }

    public void setURL(URL url) {
        this._urlString = url.toString();
        this._url = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL() throws MalformedURLException {
        Content content = this;
        synchronized (content) {
            if (this._url == null) {
                try {
                    this._url = new URL(this._urlString);
                }
                catch (MalformedURLException e) {
                    this._uri = new File(this._urlString).toURI().normalize();
                    this._url = this._uri.toURL();
                }
            }
        }
        return this._url;
    }

    public void setURL(String url) {
        this._urlString = url.trim();
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    public long getLength() {
        return this._length;
    }

    public void setLength(long length) {
        this._length = length;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public void setLastModified(long lastModified) {
        this._lastModified = lastModified;
    }

    public long getDuration() {
        return this._duration;
    }

    public void setDuration(long duration) {
        this._duration = duration;
    }

    public int getWidth() {
        return this._width;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public int getHeight() {
        return this._height;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Content content = this;
        synchronized (content) {
            return this._connected != null && this._connected != false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        boolean connect = false;
        Content content = this;
        synchronized (content) {
            if (this._connected == null) {
                this._connected = Boolean.FALSE;
                connect = true;
            }
        }
        if (connect) {
            URL url = this.getURL();
            URLConnection conn = url.openConnection();
            conn.setAllowUserInteraction(false);
            conn.setDoInput(true);
            conn.setDoOutput(false);
            conn.setUseCaches(true);
            conn.connect();
            String encoding = conn.getContentEncoding();
            long length = conn.getContentLength();
            String type = conn.getContentType();
            long lastModified = conn.getLastModified();
            if (encoding != null) {
                this._encoding = encoding;
            }
            if (length >= 0L) {
                this._length = length;
            }
            if (type != null && !"content/unknown".equals(type)) {
                this._type = type;
            }
            if (lastModified > 0L) {
                this._lastModified = lastModified;
            }
            Content content2 = this;
            synchronized (content2) {
                this._connected = Boolean.TRUE;
            }
        }
    }

    public boolean equals(Object obj) {
        return obj != null && this._urlString.equals(obj.toString());
    }

    public int hashCode() {
        return this._urlString.hashCode();
    }

    public String toString() {
        return this._urlString;
    }
}

