/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.content;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.content.ContentMetadataProvider;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ContentMetadataCenter {
    private static ContentMetadataCenter _instance = null;
    private final ServiceLoader<ContentMetadataProvider> _serviceLoader;
    private final Logger logger = LogManager.getLogger(ContentMetadataCenter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentMetadataCenter getInstance() {
        Class<ContentMetadataCenter> clazz = ContentMetadataCenter.class;
        synchronized (ContentMetadataCenter.class) {
            if (_instance == null) {
                _instance = new ContentMetadataCenter();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private ContentMetadataCenter() {
        this._serviceLoader = ServiceLoader.load(ContentMetadataProvider.class);
    }

    public void reloadProviders() {
        this._serviceLoader.reload();
    }

    public boolean fillMetadata(Content content) {
        boolean ret = false;
        for (ContentMetadataProvider service : this._serviceLoader) {
            try {
                service.fillMetadata(content);
                ret = true;
                break;
            }
            catch (Throwable e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Metadata provider " + service + " cannot handle content <" + content + ">", e);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Metadata provider " + service + " cannot handle content <" + content + ">: " + e);
            }
        }
        return ret;
    }
}

