/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.content;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.content.ContentMetadataProvider;
import java.net.URL;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiSystem;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundMetadataProvider
implements ContentMetadataProvider {
    private final Logger logger = LogManager.getLogger(SoundMetadataProvider.class);

    @Override
    public void fillMetadata(Content content) throws Exception {
        URL url = content.getURL();
        try {
            AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(url);
            content.setWidth(0);
            content.setHeight(0);
            AudioFormat audioFormat = audioFileFormat.getFormat();
            if (audioFileFormat.getFrameLength() == -1 || audioFormat.getSampleRate() == -1.0f) {
                this.logger.debug("Unknown audio duration");
            } else {
                content.setDuration((long)((float)audioFileFormat.getFrameLength() * 1000.0f / audioFormat.getSampleRate()));
            }
            return;
        }
        catch (UnsupportedAudioFileException e) {
            this.logger.debug(e.toString());
            MidiFileFormat midiFormat = MidiSystem.getMidiFileFormat(url);
            content.setWidth(0);
            content.setHeight(0);
            long duration = midiFormat.getMicrosecondLength();
            if (duration == -1L) {
                this.logger.debug("Unknown MIDI duration");
            } else {
                content.setDuration((duration + 999L) / 1000L);
            }
            return;
        }
    }
}

