/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.content.type;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.playlist.SpecificPlaylistProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class ContentTypesFileFilter
extends FileFilter {
    private final List<ContentType> _types = new ArrayList<ContentType>();
    private final String _title;
    private final boolean _includeExtensionsInDescription;
    private SpecificPlaylistProvider _provider = null;

    public ContentTypesFileFilter(String title, boolean includeExtensionsInDescription) {
        this._title = title.trim();
        this._includeExtensionsInDescription = includeExtensionsInDescription;
    }

    public void addContentType(ContentType contentType) {
        this._types.add(contentType);
    }

    public List<ContentType> getContentTypes() {
        return this._types;
    }

    @Override
    public String getDescription() {
        StringBuilder sb = new StringBuilder(this._title);
        if (this._includeExtensionsInDescription) {
            boolean first = true;
            for (ContentType type : this._types) {
                for (String ext : type.getExtensions()) {
                    if (first) {
                        sb.append(" (");
                    } else {
                        sb.append(", ");
                    }
                    first = false;
                    sb.append(ext);
                }
            }
            if (!first) {
                sb.append(')');
            }
        }
        return sb.toString();
    }

    @Override
    public boolean accept(File f) {
        boolean ret = false;
        for (ContentType type : this._types) {
            ret = ret || type.accept(f);
        }
        return ret;
    }

    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }
}

