/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist;

import io.github.borewit.lizzy.playlist.AbstractPlaylistProvider;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class JaxbPlaylistProvider<T>
extends AbstractPlaylistProvider {
    private final Class<T> xmlClass;
    private JAXBContext jaxbContext = null;

    public JaxbPlaylistProvider(Class<T> xmlClass) {
        this.xmlClass = xmlClass;
    }

    public Class<T> getXmlCLass() {
        return this.xmlClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAXBContext getJaxbContext() throws JAXBException {
        JaxbPlaylistProvider jaxbPlaylistProvider = this;
        synchronized (jaxbPlaylistProvider) {
            if (this.jaxbContext == null) {
                this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{this.getXmlCLass()});
            }
            return this.jaxbContext;
        }
    }

    protected Charset getDefaultEncoding() {
        return StandardCharsets.UTF_8;
    }

    protected JAXBElement<T> unmarshal(InputStream in, String encoding) throws JAXBException, XMLStreamException {
        String applyEncoding = encoding == null ? this.getDefaultEncoding().toString() : encoding;
        Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
        XMLStreamReader xmlStreamReader = this.getXmlStreamReader(in, applyEncoding);
        return unmarshaller.unmarshal(xmlStreamReader, this.getXmlCLass());
    }

    protected Marshaller makeMarshaller(String encoding) throws JAXBException {
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)(encoding == null ? this.getDefaultEncoding().name() : encoding));
        return marshaller;
    }

    public void writeTo(Object xmlPlaylist, OutputStream out, String encoding) throws IOException {
        try {
            Marshaller marshaller = this.makeMarshaller(encoding);
            marshaller.marshal(xmlPlaylist, out);
            out.flush();
        }
        catch (JAXBException exception) {
            throw new IOException(exception);
        }
    }

    protected XMLStreamReader getXmlStreamReader(InputStream in, String encoding) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        return xmlInputFactory.createXMLStreamReader(in, encoding);
    }
}

