/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist;

import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.AbstractTimeContainer;
import io.github.borewit.lizzy.playlist.BasePlaylistVisitor;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.PlaylistVisitor;
import io.github.borewit.lizzy.playlist.Sequence;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Playlist {
    private final Logger logger = LogManager.getLogger(Playlist.class);
    private static final PlaylistVisitor NORMALIZATION = new Normalization();
    private final Sequence _rootSequence = new Sequence();

    public Sequence getRootSequence() {
        return this._rootSequence;
    }

    public void normalize() {
        try {
            this._rootSequence.acceptDown(NORMALIZATION);
            this._rootSequence.acceptDown(NORMALIZATION);
        }
        catch (Exception e) {
            this.logger.error("Unexpected error condition", (Throwable)e);
        }
    }

    public void acceptDown(PlaylistVisitor visitor) throws IOException {
        visitor.beginVisitPlaylist(this);
        this._rootSequence.acceptDown(visitor);
        visitor.endVisitPlaylist(this);
    }

    public void acceptUp(PlaylistVisitor visitor) throws IOException {
        visitor.beginVisitPlaylist(this);
        visitor.endVisitPlaylist(this);
    }

    private static class Normalization
    extends BasePlaylistVisitor {
        private final Logger logger = LogManager.getLogger(Normalization.class);

        private Normalization() {
        }

        @Override
        public void endVisitMedia(Media target) {
            if (target.getSource() == null) {
                this.logger.info("Removing media with no source: " + target);
                target.getParent().removeComponent(target);
            }
        }

        @Override
        public void endVisitParallel(Parallel target) {
            this.endVisitTimeContainer(target);
        }

        @Override
        public void endVisitSequence(Sequence target) {
            AbstractPlaylistComponent[] targetComponents;
            this.endVisitTimeContainer(target);
            if (target.getParent() == null && target.getComponentsNumber() == 1 && (targetComponents = target.getComponentsAsArray())[0] instanceof Sequence) {
                Sequence sequence = (Sequence)targetComponents[0];
                this.logger.info("Merging root sequence " + target + " with its single child sequence " + sequence);
                target.setRepeatCount(Float.valueOf(target.getRepeatCount() * sequence.getRepeatCount()));
                AbstractPlaylistComponent[] components = sequence.getComponentsAsArray();
                target.removeComponent(sequence);
                for (AbstractPlaylistComponent component : components) {
                    target.addComponent(component);
                }
            }
            this.mergeConsecutiveIdenticalMedia(target);
            this.mergeConsecutiveSequences(target);
        }

        private void endVisitTimeContainer(AbstractTimeContainer target) {
            AbstractTimeContainer targetParent = target.getParent();
            if (targetParent != null) {
                int componentsNumber = target.getComponentsNumber();
                if (componentsNumber == 0) {
                    this.logger.info("Removing empty time container " + target);
                    targetParent.removeComponent(target);
                } else if (componentsNumber == 1) {
                    AbstractPlaylistComponent[] targetComponents = target.getComponentsAsArray();
                    this.logger.info("Replacing time container " + target + " with its single child component " + targetComponents[0]);
                    targetComponents[0].setRepeatCount(Float.valueOf(targetComponents[0].getRepeatCount() * target.getRepeatCount()));
                    target.removeComponent(targetComponents[0]);
                    targetParent.removeComponent(target);
                    targetParent.addComponent(targetComponents[0]);
                }
            }
        }

        private void mergeConsecutiveIdenticalMedia(Sequence target) {
            AbstractPlaylistComponent[] targetComponents = target.getComponentsAsArray();
            for (int i = 0; i < targetComponents.length - 1; ++i) {
                Media media2;
                if (!(targetComponents[i] instanceof Media)) continue;
                Media media1 = (Media)targetComponents[i];
                int upTo = i;
                int j = i + 1;
                while (j < targetComponents.length && targetComponents[j] instanceof Media && (media2 = (Media)targetComponents[j]).getSource() != null && media2.getSource().equals(media1.getSource()) && (media2.getDuration() != null || media1.getDuration() == null) && (media2.getDuration() == null || media2.getDuration().equals(media1.getDuration()))) {
                    upTo = j++;
                }
                if (upTo <= i) continue;
                Sequence newSequence = new Sequence();
                newSequence.setRepeatCount(Float.valueOf(1 + upTo - i));
                this.logger.info("Merging " + newSequence.getRepeatCount() + " identical media in a new sequence");
                target.addComponent(i, newSequence);
                for (int j2 = i; j2 <= upTo; ++j2) {
                    target.removeComponent(i + 1);
                    newSequence.addComponent(targetComponents[j2]);
                }
                i = upTo;
            }
        }

        private void mergeConsecutiveSequences(Sequence target) {
            AbstractPlaylistComponent[] targetComponents = target.getComponentsAsArray();
            for (int i = targetComponents.length - 1; i > 0; --i) {
                if (!(targetComponents[i - 1] instanceof Sequence) || !(targetComponents[i] instanceof Sequence)) continue;
                Sequence seq1 = (Sequence)targetComponents[i - 1];
                Sequence seq2 = (Sequence)targetComponents[i];
                if (seq1.getRepeatCount() != seq2.getRepeatCount()) continue;
                this.logger.info("Merging sequence " + seq2 + " in sequence " + seq1);
                seq2.getComponents().forEach(seq1::addComponent);
                target.removeComponent(seq2);
            }
        }
    }
}

