/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.playlist.PlaylistFormat;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.SpecificPlaylistProvider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class SpecificPlaylistFactory {
    private static SpecificPlaylistFactory _instance = null;
    private final ServiceLoader<SpecificPlaylistProvider> _serviceLoader;
    private final Logger logger = LogManager.getLogger(SpecificPlaylistFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpecificPlaylistFactory getInstance() {
        Class<SpecificPlaylistFactory> clazz = SpecificPlaylistFactory.class;
        synchronized (SpecificPlaylistFactory.class) {
            if (_instance == null) {
                _instance = new SpecificPlaylistFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private SpecificPlaylistFactory() {
        this._serviceLoader = ServiceLoader.load(SpecificPlaylistProvider.class);
    }

    public void reloadProviders() {
        this._serviceLoader.reload();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SpecificPlaylist readFrom(Path playlistPath, OpenOption ... options) throws IOException {
        List<SpecificPlaylistProvider> playlistProviders = this.findProvidersByExtension(playlistPath);
        Iterator<SpecificPlaylistProvider> iterator = playlistProviders.iterator();
        while (iterator.hasNext()) {
            SpecificPlaylistProvider playlistProvider = iterator.next();
            InputStream is = Files.newInputStream(playlistPath, options);
            try {
                SpecificPlaylist specificPlaylist = playlistProvider.readFrom(is, null);
                if (specificPlaylist == null) continue;
                SpecificPlaylist specificPlaylist2 = specificPlaylist;
                return specificPlaylist2;
            }
            catch (IOException e) {
                throw new IOException(String.format("Failed to read playlist using provider-id=%s: \"%s\"", playlistProvider.getId(), playlistPath));
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpecificPlaylist readFrom(URL url) throws IOException {
        SpecificPlaylist ret = null;
        for (SpecificPlaylistProvider service : this._serviceLoader) {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setAllowUserInteraction(false);
            urlConnection.setConnectTimeout(10000);
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(false);
            urlConnection.setReadTimeout(60000);
            urlConnection.setUseCaches(true);
            urlConnection.connect();
            String contentEncoding = urlConnection.getContentEncoding();
            try (InputStream in = urlConnection.getInputStream();){
                ret = service.readFrom(in, contentEncoding);
                if (ret != null) break;
            }
        }
        return ret;
    }

    public SpecificPlaylist readFrom(File file) throws IOException {
        return this.readFrom(file.toURI().toURL());
    }

    public SpecificPlaylistProvider getProvider(PlaylistFormat playlistFormat) {
        return playlistFormat == null ? null : this.findProviderById(playlistFormat.name());
    }

    public SpecificPlaylistProvider findProviderById(String id) {
        SpecificPlaylistProvider ret = null;
        for (SpecificPlaylistProvider service : this._serviceLoader) {
            if (!id.equalsIgnoreCase(service.getId())) continue;
            ret = service;
            break;
        }
        return ret;
    }

    public List<SpecificPlaylistProvider> findProvidersByExtension(Path playlistPath) {
        return this.findProvidersByExtension(playlistPath.getFileName().toString());
    }

    public List<SpecificPlaylistProvider> findProvidersByExtension(String filename) {
        LinkedList<SpecificPlaylistProvider> specificPlaylistProviders = new LinkedList<SpecificPlaylistProvider>();
        String name = filename.toLowerCase(Locale.ENGLISH);
        for (SpecificPlaylistProvider service : this._serviceLoader) {
            ContentType[] types;
            for (ContentType type : types = service.getContentTypes()) {
                if (!type.matchExtension(name)) continue;
                specificPlaylistProviders.add(service);
            }
        }
        return specificPlaylistProviders;
    }

    public List<SpecificPlaylistProvider> getProviders() {
        ArrayList<SpecificPlaylistProvider> ret = new ArrayList<SpecificPlaylistProvider>();
        for (SpecificPlaylistProvider service : this._serviceLoader) {
            ret.add(service);
        }
        return ret;
    }
}

