/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.asx;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.asx.AsxProvider;
import io.github.borewit.lizzy.playlist.xml.asx.Asx;
import io.github.borewit.lizzy.playlist.xml.asx.DurationElement;
import io.github.borewit.lizzy.playlist.xml.asx.ENTRY;
import io.github.borewit.lizzy.playlist.xml.asx.REPEAT;
import io.github.borewit.lizzy.playlist.xml.asx.RefElement;
import java.io.IOException;
import java.io.OutputStream;

public class AsxPlaylistAdapter
extends AbstractPlaylist {
    private final AsxProvider provider;
    private final Asx asx;

    private static Asx makeAsx() {
        Asx asx = new Asx();
        asx.setVERSION("3.0");
        return asx;
    }

    public AsxPlaylistAdapter(AsxProvider provider) {
        this(provider, AsxPlaylistAdapter.makeAsx());
    }

    public AsxPlaylistAdapter(AsxProvider provider, Asx asx) {
        this.provider = provider;
        this.asx = asx;
    }

    public Asx getAsx() {
        return this.asx;
    }

    @Override
    public AsxProvider getProvider() {
        return this.provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        this.provider.writeTo(this.asx, out, encoding);
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        this.asx.getENTRYOrENTRYREF().forEach(entry -> this.addToSequence(entry, ret.getRootSequence()));
        this.asx.getREPEAT().forEach(entry -> this.addRepeatToSequence((REPEAT)entry, ret.getRootSequence()));
        ret.normalize();
        return ret;
    }

    private void addToSequence(Object entryOrEntryRef, Sequence currentSequence) {
        if (entryOrEntryRef instanceof ENTRY) {
            ENTRY entry = (ENTRY)entryOrEntryRef;
            if (entry.getREF() != null && entry.getREF().getHREF() != null) {
                Media media = new Media();
                media.setSource(new Content(entry.getREF().getHREF()));
                DurationElement duration = entry.getDURATION();
                if (duration == null) {
                    duration = entry.getDURATION();
                }
                currentSequence.addComponent(media);
            }
        } else if (entryOrEntryRef instanceof RefElement) {
            RefElement entryRef = (RefElement)entryOrEntryRef;
            Media media = new Media();
            media.setSource(new Content(entryRef.getHREF()));
            currentSequence.addComponent(media);
        }
    }

    private void addRepeatToSequence(REPEAT repeat, Sequence currentSequence) {
        Sequence repeatSeq = new Sequence();
        repeatSeq.setRepeatCount(Float.valueOf(repeat.getCOUNT() == null ? 1.0f : (float)(repeat.getCOUNT() + 1)));
        currentSequence.addComponent(repeatSeq);
        repeat.getENTRYOrENTRYREF().forEach(asxElem -> this.addToSequence(asxElem, repeatSeq));
    }
}

