/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.asx;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.JaxbPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.asx.AsxPlaylistAdapter;
import io.github.borewit.lizzy.playlist.xml.asx.Asx;
import io.github.borewit.lizzy.playlist.xml.asx.ContainerElement;
import io.github.borewit.lizzy.playlist.xml.asx.DurationElement;
import io.github.borewit.lizzy.playlist.xml.asx.ENTRY;
import io.github.borewit.lizzy.playlist.xml.asx.REPEAT;
import io.github.borewit.lizzy.playlist.xml.asx.RefElement;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;

public class AsxProvider
extends JaxbPlaylistProvider<Asx> {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".asx"}, new String[]{"video/x-ms-asf"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINAMP, false, null), new PlayerSupport(PlayerSupport.Player.VLC_MEDIA_PLAYER, false, null), new PlayerSupport(PlayerSupport.Player.WINDOWS_MEDIA_PLAYER, true, null), new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, true, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Advanced Stream Redirector (ASX)"), new ContentType(new String[]{".wmx"}, new String[]{"video/x-ms-wvx"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Windows Media Redirector (WMX)"), new ContentType(new String[]{".wvx"}, new String[]{"video/x-ms-wvx"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINDOWS_MEDIA_PLAYER, false, null), new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, false, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Windows Media Video Redirector (WVX)"), new ContentType(new String[]{".wax"}, new String[]{"audio/x-ms-wax"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINDOWS_MEDIA_PLAYER, false, null), new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, false, null), new PlayerSupport(PlayerSupport.Player.REALPLAYER, false, null)}, "Windows Media Audio Redirector (WAX)")};

    public AsxProvider() {
        super(Asx.class);
    }

    @Override
    public String getId() {
        return "asx";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    protected Charset getDefaultEncoding() {
        return StandardCharsets.US_ASCII;
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        try {
            JAXBElement asx = this.unmarshal(inputStream, encoding);
            String rootElementName = asx.getName().getLocalPart();
            return rootElementName != null && rootElementName.equalsIgnoreCase("ASX") ? new AsxPlaylistAdapter(this, (Asx)asx.getValue()) : null;
        }
        catch (JAXBException | XMLStreamException exception) {
            throw new IOException(exception.getMessage(), exception);
        }
    }

    @Override
    protected Marshaller makeMarshaller(String encoding) throws JAXBException {
        Marshaller marshaller = super.makeMarshaller(encoding);
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return marshaller;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws IOException {
        AsxPlaylistAdapter asxPlaylist = new AsxPlaylistAdapter(this);
        this.addToPlaylist(asxPlaylist.getAsx(), playlist.getRootSequence());
        return asxPlaylist;
    }

    private void addToPlaylist(ContainerElement asxContainer, AbstractPlaylistComponent component) {
        if (component instanceof Sequence) {
            Sequence sequence = (Sequence)component;
            if (sequence.getRepeatCount() > 1.0f && asxContainer instanceof Asx) {
                Asx asx = (Asx)asxContainer;
                REPEAT repeat = new REPEAT();
                repeat.setCOUNT((int)(sequence.getRepeatCount() - 1.0f));
                asx.getREPEAT().add(repeat);
                sequence.getComponents().forEach(child -> this.addToPlaylist(repeat, (AbstractPlaylistComponent)child));
            } else {
                sequence.getComponents().forEach(child -> this.addToPlaylist(asxContainer, (AbstractPlaylistComponent)child));
            }
        } else {
            Media media;
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A parallel time container is incompatible with an ASX playlist");
            }
            if (component instanceof Media && (media = (Media)component).getSource() != null) {
                if (media.getRepeatCount() > 1.0f && asxContainer instanceof Asx) {
                    Asx asx = (Asx)asxContainer;
                    REPEAT repeat = new REPEAT();
                    repeat.setCOUNT((int)(media.getRepeatCount() - 1.0f));
                    asx.getREPEAT().add(repeat);
                    this.addToPlaylist(repeat, media);
                } else {
                    boolean isPlaylist = false;
                    String path = media.getSource().toString().toLowerCase();
                    for (ContentType type : FILETYPES) {
                        for (String extension : type.getExtensions()) {
                            isPlaylist = isPlaylist || path.endsWith(extension);
                        }
                    }
                    if (isPlaylist) {
                        if (media.getDuration() != null) {
                            throw new IllegalArgumentException("An ASX playlist referenced in another ASX playlist cannot be timed");
                        }
                        RefElement entryRef = new RefElement();
                        entryRef.setHREF(media.getSource().toString());
                        asxContainer.getENTRYOrENTRYREF().add(entryRef);
                    } else {
                        ENTRY entry = new ENTRY();
                        RefElement reference = new RefElement();
                        reference.setHREF(media.getSource().toString());
                        if (media.getDuration() != null) {
                            DurationElement durationElement = new DurationElement();
                        }
                        entry.setREF(reference);
                        asxContainer.getENTRYOrENTRYREF().add(entry);
                    }
                }
            }
        }
    }

    @Override
    protected XMLStreamReader getXmlStreamReader(InputStream in, String encoding) throws XMLStreamException {
        return new AsxStreamReaderDelegate(super.getXmlStreamReader(in, encoding));
    }

    private static class AsxStreamReaderDelegate
    extends StreamReaderDelegate {
        AsxStreamReaderDelegate(XMLStreamReader xsr) {
            super(xsr);
        }

        @Override
        public String getAttributeLocalName(int index) {
            return super.getAttributeLocalName(index).toUpperCase();
        }

        @Override
        public String getLocalName() {
            return super.getLocalName().toUpperCase();
        }
    }
}

