/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.atom;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.atom.AtomProvider;
import io.github.borewit.lizzy.playlist.xml.atom.EntryType;
import io.github.borewit.lizzy.playlist.xml.atom.FeedType;
import io.github.borewit.lizzy.playlist.xml.atom.Link;
import io.github.borewit.lizzy.playlist.xml.atom.ObjectFactory;
import java.io.IOException;
import java.io.OutputStream;

public class AtomPlaylist
extends AbstractPlaylist {
    private final AtomProvider provider;
    private final FeedType feed;

    public AtomPlaylist(AtomProvider provider, FeedType feed) {
        this.provider = provider;
        this.feed = feed;
    }

    @Override
    public AtomProvider getProvider() {
        return this.provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        this.provider.writeTo(new ObjectFactory().createFeed(this.feed), out, encoding);
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (EntryType entry : this.feed.getEntry()) {
            for (Link link : entry.getLink()) {
                if (link.getHref() == null || !"enclosure".equals(link.getRel())) continue;
                Media media = new Media();
                Content content = new Content(link.getHref());
                content.setType(link.getType());
                if (link.getLength() != null) {
                    content.setLength(link.getLength());
                }
                media.setSource(content);
                ret.getRootSequence().addComponent(media);
            }
        }
        ret.normalize();
        return ret;
    }
}

