/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.atom;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.JaxbPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.atom.AtomPlaylist;
import io.github.borewit.lizzy.playlist.xml.atom.AtomDateConstruct;
import io.github.borewit.lizzy.playlist.xml.atom.AtomTextConstruct;
import io.github.borewit.lizzy.playlist.xml.atom.EntryType;
import io.github.borewit.lizzy.playlist.xml.atom.FeedType;
import io.github.borewit.lizzy.playlist.xml.atom.Generator;
import io.github.borewit.lizzy.playlist.xml.atom.Id;
import io.github.borewit.lizzy.playlist.xml.atom.Link;
import io.github.borewit.lizzy.xml.Version;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.stream.XMLStreamException;

public class AtomProvider
extends JaxbPlaylistProvider<FeedType> {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".atom", ".xml"}, new String[]{"application/atom+xml"}, new PlayerSupport[0], "Atom Document")};

    public AtomProvider() {
        super(FeedType.class);
    }

    @Override
    public String getId() {
        return "atom";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        try {
            JAXBElement feed = this.unmarshal(inputStream, encoding);
            String rootElementName = feed.getName().getLocalPart();
            return rootElementName != null && rootElementName.equalsIgnoreCase("Feed") ? new AtomPlaylist(this, (FeedType)feed.getValue()) : null;
        }
        catch (JAXBException | XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) {
        FeedType feed = new FeedType();
        feed.setTitle(AtomProvider.toAtomText("Lizzy v" + Version.CURRENT + " Atom playlist"));
        feed.setUpdated(AtomProvider.toAtomDate(new Date()));
        Id id = new Id();
        StringBuilder sb = new StringBuilder();
        sb.append("urn:uuid:");
        String tmpId = Integer.toHexString(System.identityHashCode(feed));
        for (int i = tmpId.length(); i < 8; ++i) {
            sb.append('0');
        }
        sb.append(tmpId);
        sb.append("-d399-11d9-b93C-0003939e0af6");
        id.setContent(sb.toString());
        feed.setId(id);
        Generator generator = new Generator();
        generator.setContent("Lizzy");
        generator.setVersion(Version.CURRENT.toString());
        generator.setUri("http://sourceforge.net/projects/lizzy/");
        feed.setGenerator(generator);
        this.addToPlaylist(feed, playlist.getRootSequence());
        return new AtomPlaylist(this, feed);
    }

    private static AtomTextConstruct toAtomText(String title) {
        AtomTextConstruct atomTextConstruct = new AtomTextConstruct();
        atomTextConstruct.setValue(title);
        return atomTextConstruct;
    }

    private static AtomDateConstruct toAtomDate(long time) {
        return AtomProvider.toAtomDate(new Date(time));
    }

    private static AtomDateConstruct toAtomDate(Date date) {
        AtomDateConstruct atomDateConstruct = new AtomDateConstruct();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        try {
            atomDateConstruct.setValue(DatatypeFactory.newInstance().newXMLGregorianCalendar(c));
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        return new AtomDateConstruct();
    }

    private void addToPlaylist(FeedType feed, AbstractPlaylistComponent component) {
        block16: {
            block15: {
                if (!(component instanceof Sequence)) break block15;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0.0f) {
                    throw new IllegalArgumentException("An Atom playlist cannot handle a sequence repeated indefinitely");
                }
                int iter = 0;
                while ((float)iter < sequence.getRepeatCount()) {
                    sequence.getComponents().forEach(c -> this.addToPlaylist(feed, (AbstractPlaylistComponent)c));
                    ++iter;
                }
                break block16;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("An Atom playlist doesn't support concurrent media");
            }
            if (!(component instanceof Media)) break block16;
            Media media = (Media)component;
            Date now = new Date();
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("An Atom playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0.0f) {
                throw new IllegalArgumentException("An Atom playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                int iter = 0;
                while ((float)iter < media.getRepeatCount()) {
                    URI uri;
                    EntryType entry = new EntryType();
                    Link link = new Link();
                    try {
                        uri = media.getSource().getURI();
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                    link.setHref(uri.toString());
                    link.setRel("enclosure");
                    link.setType(media.getSource().getType());
                    if (media.getSource().getLength() >= 0L) {
                        link.setLength(media.getSource().getLength());
                    }
                    entry.getLink().add(link);
                    AtomTextConstruct title = new AtomTextConstruct();
                    if (uri.getPath() == null) {
                        title.setValue(media.getSource().toString());
                    } else {
                        File path = new File(uri.getPath());
                        title.setValue(path.getName());
                    }
                    entry.setTitle(title);
                    AtomDateConstruct atomDate = AtomProvider.toAtomDate(now);
                    if (media.getSource().getLastModified() > 0L) {
                        entry.setUpdated(AtomProvider.toAtomDate(media.getSource().getLastModified()));
                    } else {
                        entry.setUpdated(atomDate);
                    }
                    entry.setPublished(atomDate);
                    Id id = new Id();
                    StringBuilder sb = new StringBuilder();
                    sb.append("urn:uuid:");
                    String tmpId = Integer.toHexString(System.identityHashCode(entry));
                    for (int i = tmpId.length(); i < 8; ++i) {
                        sb.append('0');
                    }
                    sb.append(tmpId);
                    sb.append("-d399-11d9-b93C-0003939e0af6");
                    id.setContent(sb.toString());
                    entry.setId(id);
                    feed.getEntry().add(entry);
                    ++iter;
                }
            }
        }
    }
}

