/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.b4s;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.SpecificPlaylistProvider;
import io.github.borewit.lizzy.playlist.b4s.WinampXmlProvider;
import io.github.borewit.lizzy.playlist.xml.b4s.WinampXML;
import java.io.IOException;
import java.io.OutputStream;

public class WinampXmlAdapter
extends AbstractPlaylist {
    private final WinampXML winampXML;
    private final WinampXmlProvider provider;

    public WinampXmlAdapter(WinampXmlProvider provider, WinampXML winampXML) {
        this.provider = provider;
        this.winampXML = winampXML;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this.provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        this.provider.writeTo(this.winampXML, out, encoding);
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        if (this.winampXML.getPlaylist() != null) {
            for (WinampXML.Playlist.Entry entry : this.winampXML.getPlaylist().getEntry()) {
                if (entry.getPlaystring() == null) continue;
                Media media = new Media();
                Content content = new Content(entry.getPlaystring());
                if (entry.getLength() != null) {
                    content.setLength(entry.getLength());
                }
                media.setSource(content);
                ret.getRootSequence().addComponent(media);
            }
        }
        ret.normalize();
        return ret;
    }
}

