/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.b4s;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.JaxbPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.b4s.WinampXmlAdapter;
import io.github.borewit.lizzy.playlist.xml.b4s.WinampXML;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;

public class WinampXmlProvider
extends JaxbPlaylistProvider<WinampXML> {
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".b4s", ".bpl"}, new String[]{"text/xml"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.WINAMP, false, null), new PlayerSupport(PlayerSupport.Player.VLC_MEDIA_PLAYER, false, null)}, "Winamp 3+ Playlist")};

    public WinampXmlProvider() {
        super(WinampXML.class);
    }

    @Override
    public String getId() {
        return "b4s";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        try {
            JAXBElement winampXMLJAXBElement = this.unmarshal(inputStream, encoding);
            String rootElementName = winampXMLJAXBElement.getName().getLocalPart();
            return rootElementName != null && rootElementName.equalsIgnoreCase("WinampXML") ? new WinampXmlAdapter(this, (WinampXML)winampXMLJAXBElement.getValue()) : null;
        }
        catch (JAXBException | XMLStreamException exception) {
            throw new IOException(exception);
        }
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) {
        WinampXML winampXML = new WinampXML();
        WinampXML.Playlist xmlPlaylist = new WinampXML.Playlist();
        winampXML.setPlaylist(xmlPlaylist);
        this.addToPlaylist(xmlPlaylist.getEntry(), playlist.getRootSequence());
        return new WinampXmlAdapter(this, winampXML);
    }

    private void addToPlaylist(List<WinampXML.Playlist.Entry> playlist, AbstractPlaylistComponent component) {
        block9: {
            block8: {
                if (!(component instanceof Sequence)) break block8;
                Sequence sequence = (Sequence)component;
                if (sequence.getRepeatCount() < 0.0f) {
                    throw new IllegalArgumentException("A B4S playlist cannot handle a sequence repeated indefinitely");
                }
                int iter = 0;
                while ((float)iter < sequence.getRepeatCount()) {
                    sequence.getComponents().forEach(c -> this.addToPlaylist(playlist, (AbstractPlaylistComponent)c));
                    ++iter;
                }
                break block9;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A B4S playlist cannot play different media at the same time");
            }
            if (!(component instanceof Media)) break block9;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A B4S playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0.0f) {
                throw new IllegalArgumentException("A B4S playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                int iter = 0;
                while ((float)iter < media.getRepeatCount()) {
                    WinampXML.Playlist.Entry entry = new WinampXML.Playlist.Entry();
                    entry.setPlaystring(media.getSource().toString());
                    if (media.getSource().getLength() >= 0L) {
                        entry.setLength(media.getSource().getLength());
                    }
                    playlist.add(entry);
                    ++iter;
                }
            }
        }
    }
}

