/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.mpcpl;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.SpecificPlaylistProvider;
import io.github.borewit.lizzy.playlist.mpcpl.Resource;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

public class MPCPL
extends AbstractPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private final List<Resource> _resources = new ArrayList<Resource>();

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, enc));
        writer.write("MPCPLAYLIST");
        writer.newLine();
        int i = 1;
        for (Resource resource : this._resources) {
            writer.write(Integer.toString(i));
            writer.write(",type,");
            writer.write(resource.getType());
            writer.newLine();
            writer.write(Integer.toString(i));
            writer.write(",filename,");
            writer.write(resource.getFilename());
            writer.newLine();
            if (resource.getSubtitle() != null) {
                writer.write(Integer.toString(i));
                writer.write(",subtitle,");
                writer.write(resource.getSubtitle());
                writer.newLine();
            }
            ++i;
        }
        writer.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (Resource resource : this._resources) {
            if (resource.getFilename() == null) continue;
            Media media = new Media();
            Content content = new Content(resource.getFilename());
            media.setSource(content);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }

    public List<Resource> getResources() {
        return this._resources;
    }
}

