/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.mpcpl;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.AbstractPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.mpcpl.MPCPL;
import io.github.borewit.lizzy.playlist.mpcpl.Resource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MPCPLProvider
extends AbstractPlaylistProvider {
    private final Logger logger = LogManager.getLogger(MPCPLProvider.class);
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".mpcpl"}, new String[]{"text/plain"}, new PlayerSupport[]{new PlayerSupport(PlayerSupport.Player.MEDIA_PLAYER_CLASSIC, true, null)}, "Media Player Classic Playlist")};

    @Override
    public String getId() {
        return "mpcpl";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        String line;
        String enc = encoding;
        if (enc == null) {
            enc = "UTF-8";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, enc));
        MPCPL ret = new MPCPL();
        ret.setProvider(this);
        boolean magicFound = false;
        while ((line = reader.readLine()) != null) {
            int resourceIndex;
            if ((line = line.trim()).length() <= 0) continue;
            if (!magicFound) {
                if (!line.equalsIgnoreCase("MPCPLAYLIST")) {
                    throw new IllegalArgumentException("Not a MPCPL playlist format");
                }
                magicFound = true;
                continue;
            }
            int idx = line.indexOf(44);
            if (idx <= 0) {
                this.logger.error("Malformed MPCPL playlist entry " + line);
                ret = null;
                break;
            }
            String resourceIndexString = line.substring(0, idx).trim();
            if ((idx = (line = line.substring(idx + 1)).indexOf(44)) <= 0) {
                this.logger.error("Malformed MPCPL playlist entry " + line);
                ret = null;
                break;
            }
            String key = line.substring(0, idx).trim().toLowerCase();
            String value = line.substring(idx + 1).trim();
            try {
                resourceIndex = Integer.parseInt(resourceIndexString) - 1;
            }
            catch (NumberFormatException e) {
                this.logger.error(e.toString());
                ret = null;
                break;
            }
            for (int i = ret.getResources().size(); i < resourceIndex + 1; ++i) {
                ret.getResources().add(new Resource());
            }
            Resource resource = ret.getResources().get(resourceIndex);
            if ("filename".equals(key)) {
                resource.setFilename(value);
                continue;
            }
            if ("type".equals(key)) {
                resource.setType(value);
                continue;
            }
            if ("subtitle".equals(key)) {
                resource.setSubtitle(value);
                continue;
            }
            this.logger.warn("Unknown MPCPL keyword " + key);
        }
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) throws IOException {
        MPCPL ret = new MPCPL();
        ret.setProvider(this);
        this.addToPlaylist(ret.getResources(), playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(List<Resource> resources, AbstractPlaylistComponent component) {
        block8: {
            block7: {
                if (!(component instanceof Sequence)) break block7;
                Sequence seq = (Sequence)component;
                if (seq.getRepeatCount() < 0.0f) {
                    throw new IllegalArgumentException("A MPCPL playlist cannot handle a sequence repeated indefinitely");
                }
                int iter = 0;
                while ((float)iter < seq.getRepeatCount()) {
                    seq.getComponents().forEach(c -> this.addToPlaylist(resources, (AbstractPlaylistComponent)c));
                    ++iter;
                }
                break block8;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A parallel time container is incompatible with a MPCPL playlist");
            }
            if (!(component instanceof Media)) break block8;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A MPCPL playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0.0f) {
                throw new IllegalArgumentException("A MPCPL playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                int iter = 0;
                while ((float)iter < media.getRepeatCount()) {
                    Resource resource = new Resource();
                    resource.setFilename(media.getSource().toString());
                    resources.add(resource);
                    ++iter;
                }
            }
        }
    }
}

