/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.pla;

import io.github.borewit.lizzy.content.Content;
import io.github.borewit.lizzy.playlist.AbstractPlaylist;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.SpecificPlaylistProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PLA
extends AbstractPlaylist {
    private transient SpecificPlaylistProvider _provider = null;
    private final List<String> _filenames = new ArrayList<String>();

    public void setProvider(SpecificPlaylistProvider provider) {
        this._provider = provider;
    }

    @Override
    public SpecificPlaylistProvider getProvider() {
        return this._provider;
    }

    @Override
    public void writeTo(OutputStream out, String encoding) throws IOException {
        byte[] array = new byte[512];
        Arrays.fill(array, (byte)0);
        array[4] = 105;
        array[5] = 114;
        array[6] = 105;
        array[7] = 118;
        array[8] = 101;
        array[9] = 114;
        array[10] = 32;
        array[11] = 85;
        array[12] = 77;
        array[13] = 83;
        array[14] = 32;
        array[15] = 80;
        array[16] = 76;
        array[17] = 65;
        int nbSongs = this._filenames.size();
        array[3] = (byte)(nbSongs & 0xFF);
        array[2] = (byte)((nbSongs & 0xFF00) >> 8);
        array[1] = (byte)((nbSongs & 0xFF0000) >> 16);
        array[0] = (byte)((nbSongs & 0xFF000000) >> 24);
        out.write(array);
        for (String filename : this._filenames) {
            Arrays.fill(array, (byte)0);
            int slashIndex = filename.lastIndexOf(47);
            int antislashIndex = filename.lastIndexOf(92);
            int fileIndex = 0;
            if (slashIndex > antislashIndex) {
                fileIndex = slashIndex + 1;
            } else if (antislashIndex > slashIndex) {
                fileIndex = antislashIndex + 1;
            }
            array[1] = (byte)(++fileIndex & 0xFF);
            array[0] = (byte)((fileIndex & 0xFF00) >> 8);
            byte[] tmp = filename.getBytes(StandardCharsets.UTF_16BE);
            System.arraycopy(tmp, 0, array, 2, tmp.length);
            out.write(array);
        }
        out.flush();
    }

    @Override
    public Playlist toPlaylist() {
        Playlist ret = new Playlist();
        for (String filename : this._filenames) {
            Media media = new Media();
            Content content = new Content(filename);
            media.setSource(content);
            ret.getRootSequence().addComponent(media);
        }
        ret.normalize();
        return ret;
    }

    public List<String> getFilenames() {
        return this._filenames;
    }
}

