/*
 * Decompiled with CFR 0.152.
 */
package io.github.borewit.lizzy.playlist.pla;

import io.github.borewit.lizzy.content.type.ContentType;
import io.github.borewit.lizzy.player.PlayerSupport;
import io.github.borewit.lizzy.playlist.AbstractPlaylistComponent;
import io.github.borewit.lizzy.playlist.AbstractPlaylistProvider;
import io.github.borewit.lizzy.playlist.Media;
import io.github.borewit.lizzy.playlist.Parallel;
import io.github.borewit.lizzy.playlist.Playlist;
import io.github.borewit.lizzy.playlist.Sequence;
import io.github.borewit.lizzy.playlist.SpecificPlaylist;
import io.github.borewit.lizzy.playlist.pla.PLA;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PLAProvider
extends AbstractPlaylistProvider {
    private final Logger logger = LogManager.getLogger(PLAProvider.class);
    private static final ContentType[] FILETYPES = new ContentType[]{new ContentType(new String[]{".pla"}, new String[]{"application/octet-stream"}, new PlayerSupport[0], "iRiver iQuickList File")};

    @Override
    public String getId() {
        return "pla";
    }

    @Override
    public ContentType[] getContentTypes() {
        return (ContentType[])FILETYPES.clone();
    }

    @Override
    public SpecificPlaylist readFrom(InputStream inputStream, String encoding) throws IOException {
        PLA ret = new PLA();
        ret.setProvider(this);
        byte[] array = new byte[512];
        if (inputStream.read(array) != 512) {
            throw new IllegalArgumentException("Not a PLA playlist format (file too small)");
        }
        String magic = new String(array, 4, 14, StandardCharsets.US_ASCII);
        if (!"iriver UMS PLA".equals(magic)) {
            throw new IllegalArgumentException("Not a PLA playlist format (bad magic)");
        }
        int nbSongs = array[3] & 0xFF | (array[2] & 0xFF) << 8 | (array[1] & 0xFF) << 16 | (array[0] & 0xFF) << 24;
        for (int i = 0; i < nbSongs; ++i) {
            if (inputStream.read(array) != 512) {
                this.logger.error("Malformed PLA playlist (file too small)");
                ret = null;
                break;
            }
            String songFilename = new String(array, 2, 510, StandardCharsets.UTF_16BE);
            ret.getFilenames().add(songFilename);
        }
        return ret;
    }

    @Override
    public SpecificPlaylist toSpecificPlaylist(Playlist playlist) {
        PLA ret = new PLA();
        ret.setProvider(this);
        this.addToPlaylist(ret.getFilenames(), playlist.getRootSequence());
        return ret;
    }

    private void addToPlaylist(List<String> filenames, AbstractPlaylistComponent component) {
        block8: {
            block7: {
                if (!(component instanceof Sequence)) break block7;
                Sequence seq = (Sequence)component;
                if (seq.getRepeatCount() < 0.0f) {
                    throw new IllegalArgumentException("A PLA playlist cannot handle a sequence repeated indefinitely");
                }
                int iter = 0;
                while ((float)iter < seq.getRepeatCount()) {
                    seq.getComponents().forEach(c -> this.addToPlaylist(filenames, (AbstractPlaylistComponent)c));
                    ++iter;
                }
                break block8;
            }
            if (component instanceof Parallel) {
                throw new IllegalArgumentException("A parallel time container is incompatible with a PLA playlist");
            }
            if (!(component instanceof Media)) break block8;
            Media media = (Media)component;
            if (media.getDuration() != null) {
                throw new IllegalArgumentException("A PLA playlist cannot handle a timed media");
            }
            if (media.getRepeatCount() < 0.0f) {
                throw new IllegalArgumentException("A PLA playlist cannot handle a media repeated indefinitely");
            }
            if (media.getSource() != null) {
                int iter = 0;
                while ((float)iter < media.getRepeatCount()) {
                    filenames.add(media.getSource().toString());
                    ++iter;
                }
            }
        }
    }
}

